<?php
/**
 * The template for displaying all single posts and attachments
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 */

get_header(); ?>


<main>
    <?php
    // Start the loop.
    while (have_posts()) :
    the_post();
    $n_post = $post->ID;
    $cat = get_the_category();
    $n_cat = $cat[0]->slug;
    ?>

    <!-- mainframe -->
    <section class="mainframe">
        <div class="container">
            <h1 id="typtextTwo"><?php the_title(); ?></h1>
            <div class="row">
                <div class="col-sm-7">
                    <p><?php the_field('description'); ?></p>
                </div>
                <div class="col-sm-5">
                    <?php if(get_field('agency')):?><p class="text-right"><b>Agency</b><?php the_field('agency'); ?></p><?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    <!--content -->
    <section class="me-case">
        <div class="container">

            <div class="portfolio">

                <?php
                $gallery = get_post_meta($post->ID, 'wpsimplegallery_gallery', true);
                $gallery = (is_string($gallery)) ? @unserialize($gallery) : $gallery;
                if (is_array($gallery) && count($gallery) > 0) {
                    foreach ($gallery as $thumbid) {
                        $info = get_posts(array('p' => $thumbid, 'post_type' => 'attachment'));
                        $url = wp_get_attachment_url($thumbid); ?>
                        <figure class="figure thump-img mb-6 wow-normal">
                            <img src="<?= $url ?>" class="img-fluid" alt="portfolio">
                        </figure>
                    <?php }
                } ?>

            </div>
            <?php

            endwhile;
            ?>

            <div class="row d-block">

                <?php
                wp_reset_query();
                query_posts('category_name='.$n_cat.'&showposts=-1');
                $i = 1;
                $j = 0;
                while (have_posts()) : the_post();
                if($post->ID!=$n_post && $j<4) {
                    if ($i % 2 == 0) {
                        if (has_post_thumbnail()) {
                            $feat_image = wp_get_attachment_url(get_post_thumbnail_id($post->ID)); ?>
                            <div class="col-sm-6 case-right">
                                <a href="<?php the_permalink(); ?>">
                                    <figure class="figure thump-img wow-normal">
                                        <img src="<?php echo $feat_image; ?>" class="img-fluid" alt="case-study">
                                        <figcaption class="figure-caption <?php echo get_field('black_theme')?'text-black':''?>"><?php the_title(); ?>
                                            <small>
                                                <?php the_field('sub_heading'); ?></small>
                                        </figcaption>
                                </a>
                                </figure>
                            </div>
                            <?php
                        }
                    } else {
                        if (has_post_thumbnail()) {
                            $feat_image = wp_get_attachment_url(get_post_thumbnail_id($post->ID)); ?>
                            <div class="col-sm-6 case-left mt-m">
                                <a href="<?php the_permalink(); ?>">
                                    <figure class="figure thump-img wow-delay">
                                        <img src="<?php echo $feat_image; ?>" class="img-fluid" alt="case-study">
                                        <figcaption class="figure-caption <?php echo get_field('black_theme')?'text-black':''?>"><?php the_title(); ?>
                                            <small>
                                                <?php the_field('sub_heading'); ?></small>
                                        </figcaption>
                                    </figure>
                                </a>
                            </div>
                            <?php
                        }
                    }
                    $i++;
                    $j++;
                }
                endwhile;
                ?>


            </div>
        </div>


    </section>


</main>

<?php get_footer(); ?>
