dynamic class caurina.transitions.SpecialPropertiesDefault
{

    function SpecialPropertiesDefault()
    {
        trace("SpecialProperties is an static class and should not be instantiated.");
    }

    static function init()
    {
        caurina.transitions.Tweener.registerSpecialProperty("_frame", caurina.transitions.SpecialPropertiesDefault._frame_get, caurina.transitions.SpecialPropertiesDefault._frame_set);
        caurina.transitions.Tweener.registerSpecialProperty("_sound_volume", caurina.transitions.SpecialPropertiesDefault._sound_volume_get, caurina.transitions.SpecialPropertiesDefault._sound_volume_set);
        caurina.transitions.Tweener.registerSpecialProperty("_sound_pan", caurina.transitions.SpecialPropertiesDefault._sound_pan_get, caurina.transitions.SpecialPropertiesDefault._sound_pan_set);
        caurina.transitions.Tweener.registerSpecialProperty("_color_ra", caurina.transitions.SpecialPropertiesDefault._color_property_get, caurina.transitions.SpecialPropertiesDefault._color_property_set, ["ra"]);
        caurina.transitions.Tweener.registerSpecialProperty("_color_rb", caurina.transitions.SpecialPropertiesDefault._color_property_get, caurina.transitions.SpecialPropertiesDefault._color_property_set, ["rb"]);
        caurina.transitions.Tweener.registerSpecialProperty("_color_ga", caurina.transitions.SpecialPropertiesDefault._color_property_get, caurina.transitions.SpecialPropertiesDefault._color_property_set, ["ga"]);
        caurina.transitions.Tweener.registerSpecialProperty("_color_gb", caurina.transitions.SpecialPropertiesDefault._color_property_get, caurina.transitions.SpecialPropertiesDefault._color_property_set, ["gb"]);
        caurina.transitions.Tweener.registerSpecialProperty("_color_ba", caurina.transitions.SpecialPropertiesDefault._color_property_get, caurina.transitions.SpecialPropertiesDefault._color_property_set, ["ba"]);
        caurina.transitions.Tweener.registerSpecialProperty("_color_bb", caurina.transitions.SpecialPropertiesDefault._color_property_get, caurina.transitions.SpecialPropertiesDefault._color_property_set, ["bb"]);
        caurina.transitions.Tweener.registerSpecialProperty("_color_aa", caurina.transitions.SpecialPropertiesDefault._color_property_get, caurina.transitions.SpecialPropertiesDefault._color_property_set, ["aa"]);
        caurina.transitions.Tweener.registerSpecialProperty("_color_ab", caurina.transitions.SpecialPropertiesDefault._color_property_get, caurina.transitions.SpecialPropertiesDefault._color_property_set, ["ab"]);
        caurina.transitions.Tweener.registerSpecialProperty("_autoAlpha", caurina.transitions.SpecialPropertiesDefault._autoAlpha_get, caurina.transitions.SpecialPropertiesDefault._autoAlpha_set);
        caurina.transitions.Tweener.registerSpecialPropertySplitter("_color", caurina.transitions.SpecialPropertiesDefault._color_splitter);
        caurina.transitions.Tweener.registerSpecialPropertySplitter("_colorTransform", caurina.transitions.SpecialPropertiesDefault._colorTransform_splitter);
        caurina.transitions.Tweener.registerSpecialPropertySplitter("_scale", caurina.transitions.SpecialPropertiesDefault._scale_splitter);
        caurina.transitions.Tweener.registerSpecialProperty("_blur_blurX", caurina.transitions.SpecialPropertiesDefault._filter_property_get, caurina.transitions.SpecialPropertiesDefault._filter_property_set, [flash.filters.BlurFilter, "blurX"]);
        caurina.transitions.Tweener.registerSpecialProperty("_blur_blurY", caurina.transitions.SpecialPropertiesDefault._filter_property_get, caurina.transitions.SpecialPropertiesDefault._filter_property_set, [flash.filters.BlurFilter, "blurY"]);
        caurina.transitions.Tweener.registerSpecialProperty("_blur_quality", caurina.transitions.SpecialPropertiesDefault._filter_property_get, caurina.transitions.SpecialPropertiesDefault._filter_property_set, [flash.filters.BlurFilter, "quality"]);
        caurina.transitions.Tweener.registerSpecialPropertySplitter("_filter", caurina.transitions.SpecialPropertiesDefault._filter_splitter);
        caurina.transitions.Tweener.registerSpecialPropertyModifier("_bezier", caurina.transitions.SpecialPropertiesDefault._bezier_modifier, caurina.transitions.SpecialPropertiesDefault._bezier_get);
    }

    static function _color_splitter(p_value)
    {
        var __reg1 = new Array();
        if (p_value == null) 
        {
            __reg1.push({name: "_color_ra", value: 100});
            __reg1.push({name: "_color_rb", value: 0});
            __reg1.push({name: "_color_ga", value: 100});
            __reg1.push({name: "_color_gb", value: 0});
            __reg1.push({name: "_color_ba", value: 100});
            __reg1.push({name: "_color_bb", value: 0});
        }
        else 
        {
            __reg1.push({name: "_color_ra", value: 0});
            __reg1.push({name: "_color_rb", value: caurina.transitions.AuxFunctions.numberToR(p_value)});
            __reg1.push({name: "_color_ga", value: 0});
            __reg1.push({name: "_color_gb", value: caurina.transitions.AuxFunctions.numberToG(p_value)});
            __reg1.push({name: "_color_ba", value: 0});
            __reg1.push({name: "_color_bb", value: caurina.transitions.AuxFunctions.numberToB(p_value)});
        }
        return __reg1;
    }

    static function _colorTransform_splitter(p_value)
    {
        var __reg2 = new Array();
        if (p_value == null) 
        {
            __reg2.push({name: "_color_ra", value: 100});
            __reg2.push({name: "_color_rb", value: 0});
            __reg2.push({name: "_color_ga", value: 100});
            __reg2.push({name: "_color_gb", value: 0});
            __reg2.push({name: "_color_ba", value: 100});
            __reg2.push({name: "_color_bb", value: 0});
        }
        else 
        {
            if (p_value.ra != undefined) 
            {
                __reg2.push({name: "_color_ra", value: p_value.ra});
            }
            if (p_value.rb != undefined) 
            {
                __reg2.push({name: "_color_rb", value: p_value.rb});
            }
            if (p_value.ga != undefined) 
            {
                __reg2.push({name: "_color_ba", value: p_value.ba});
            }
            if (p_value.gb != undefined) 
            {
                __reg2.push({name: "_color_bb", value: p_value.bb});
            }
            if (p_value.ba != undefined) 
            {
                __reg2.push({name: "_color_ga", value: p_value.ga});
            }
            if (p_value.bb != undefined) 
            {
                __reg2.push({name: "_color_gb", value: p_value.gb});
            }
            if (p_value.aa != undefined) 
            {
                __reg2.push({name: "_color_aa", value: p_value.aa});
            }
            if (p_value.ab != undefined) 
            {
                __reg2.push({name: "_color_ab", value: p_value.ab});
            }
        }
        return __reg2;
    }

    static function _scale_splitter(p_value)
    {
        var __reg1 = new Array();
        __reg1.push({name: "_xscale", value: p_value});
        __reg1.push({name: "_yscale", value: p_value});
        return __reg1;
    }

    static function _filter_splitter(p_value)
    {
        var __reg1 = new Array();
        if (p_value instanceof flash.filters.BlurFilter) 
        {
            __reg1.push({name: "_blur_blurX", value: flash.filters.BlurFilter(p_value).blurX});
            __reg1.push({name: "_blur_blurY", value: flash.filters.BlurFilter(p_value).blurY});
            __reg1.push({name: "_blur_quality", value: flash.filters.BlurFilter(p_value).quality});
        }
        else 
        {
            trace("??");
        }
        return __reg1;
    }

    static function _frame_get(p_obj)
    {
        return p_obj._currentFrame;
    }

    static function _frame_set(p_obj, p_value)
    {
        p_obj.gotoAndStop(Math.round(p_value));
    }

    static function _sound_volume_get(p_obj)
    {
        return p_obj.getVolume();
    }

    static function _sound_volume_set(p_obj, p_value)
    {
        p_obj.setVolume(p_value);
    }

    static function _sound_pan_get(p_obj)
    {
        return p_obj.getPan();
    }

    static function _sound_pan_set(p_obj, p_value)
    {
        p_obj.setPan(p_value);
    }

    static function _color_property_get(p_obj, p_parameters)
    {
        return (new Color(p_obj)).getTransform()[p_parameters[0]];
    }

    static function _color_property_set(p_obj, p_value, p_parameters)
    {
        var __reg1 = new Object();
        __reg1[p_parameters[0]] = Math.round(p_value);
        (new Color(p_obj)).setTransform(__reg1);
    }

    static function _autoAlpha_get(p_obj)
    {
        return p_obj._alpha;
    }

    static function _autoAlpha_set(p_obj, p_value)
    {
        p_obj._alpha = p_value;
        p_obj._visible = p_value > 0;
    }

    static function _filter_property_get(p_obj, p_parameters)
    {
        var __reg2 = p_obj.filters;
        var __reg1 = undefined;
        var __reg4 = p_parameters[0];
        var __reg3 = p_parameters[1];
        __reg1 = 0;
        while (__reg1 < __reg2.length) 
        {
            if (__reg2[__reg1] instanceof __reg4) 
            {
                return __reg2[__reg1][__reg3];
            }
            ++__reg1;
        }
        var __reg5 = undefined;
        if ((__reg0 = __reg4) === flash.filters.BlurFilter) 
        {
            __reg5 = {blurX: 0, blurY: 0, quality: NaN};
        }
        return __reg5[__reg3];
    }

    static function _filter_property_set(p_obj, p_value, p_parameters)
    {
        var __reg2 = p_obj.filters;
        var __reg1 = undefined;
        var __reg4 = p_parameters[0];
        var __reg3 = p_parameters[1];
        __reg1 = 0;
        while (__reg1 < __reg2.length) 
        {
            if (__reg2[__reg1] instanceof __reg4) 
            {
                __reg2[__reg1][__reg3] = p_value;
                p_obj.filters = __reg2;
                return undefined;
            }
            ++__reg1;
        }
        if (__reg2 == undefined) 
        {
            __reg2 = new Array();
        }
        var __reg7 = undefined;
        if ((__reg0 = __reg4) === flash.filters.BlurFilter) 
        {
            __reg7 = new flash.filters.BlurFilter(0, 0);
        }
        __reg7[__reg3] = p_value;
        __reg2.push(__reg7);
        p_obj.filters = __reg2;
    }

    static function _bezier_modifier(p_obj)
    {
        var __reg7 = [];
        var __reg4 = undefined;
        if (p_obj instanceof Array) 
        {
            __reg4 = p_obj.concat();
        }
        else 
        {
            __reg4 = [p_obj];
        }
        var __reg3 = undefined;
        var __reg1 = undefined;
        var __reg2 = {};
        __reg3 = 0;
        while (__reg3 < __reg4.length) 
        {
            for (__reg1 in __reg4[__reg3]) 
            {
                if (__reg2[__reg1] == undefined) 
                {
                    __reg2[__reg1] = [];
                }
                __reg2[__reg1].push(__reg4[__reg3][__reg1]);
            }
            ++__reg3;
        }
        for (__reg1 in __reg2) 
        {
            __reg7.push({name: __reg1, parameters: __reg2[__reg1]});
        }
        return __reg7;
    }

    static function _bezier_get(b, e, t, p)
    {
        if (p.length == 1) 
        {
            return b + t * (2 * (1 - t) * (p[0] - b) + t * (e - b));
        }
        var __reg2 = Math.floor(t * p.length);
        var __reg5 = (t - __reg2 * (1 / p.length)) * p.length;
        var __reg3 = undefined;
        var __reg6 = undefined;
        if (__reg2 == 0) 
        {
            __reg3 = b;
            __reg6 = (p[0] + p[1]) / 2;
        }
        else if (__reg2 == p.length - 1) 
        {
            __reg3 = (p[__reg2 - 1] + p[__reg2]) / 2;
            __reg6 = e;
        }
        else 
        {
            __reg3 = (p[__reg2 - 1] + p[__reg2]) / 2;
            __reg6 = (p[__reg2] + p[__reg2 + 1]) / 2;
        }
        return __reg3 + __reg5 * (2 * (1 - __reg5) * (p[__reg2] - __reg3) + __reg5 * (__reg6 - __reg3));
    }

}
