<?php

$new_meta_boxes = array(

	array(	"name" => "post_img_upload",
			"std" => "",
			"type" => "imageupload",
			"title" => 'Upload a Thumbnail',
			"description" => "Upload an image to use as a thumbnail (this will take priority over taking images from the post)"),
		
	array(	"name" => "post_image",
			"std" => "",
			"type" => "text",
			"title" => 'Thumbnail URL',
			"description" => 'Enter the URL of an image located on another domain (this will take priority over the video on small thumbnails)'),
			
	array(	"name" => "post_editors_choice",
			"std" => "",
			"type" => "checkbox",
			"title" => "Editor's Choice",
			"description" => "Choose this post as an 'Editor's Choice' post displayed in the 'Editor's Choice' widget"),
			
	array(	"name" => "featured",
			"std" => "",
			"type" => "checkbox",
			"title" => "Featured Post",
			"description" => "Choose this post as a 'Featured' post displayed in the 'Featured Post Slider' on the home page"),
			
);

function new_meta_boxes($page) {
	global $post, $new_meta_boxes;	
	
	echo '<style>.metabox td { padding-top: 10px; } .metabox th { width:220px; vertical-align:top; } .metabox .labelpadding { padding-top:16px; } .metabox label { font-size:12px;font-weight:bold; } .medium-text { width:380px; } textarea.medium-text { height:80px; } .form-table input.checkbox { border:none;margin:-2px 10px 0 0; }</style>';
	echo '<table class="form-table metabox"><tbody>';	
	
	foreach($new_meta_boxes as $meta_box) {
		$meta_box_value = get_post_meta($post->ID, $meta_box['name'].'_value', true);
		
		if($meta_box_value == "")
			$meta_box_value = $meta_box['std'];	
		
		echo'<input type="hidden" name="'.$meta_box['name'].'_noncename" id="'.$meta_box['name'].'_noncename" value="'.wp_create_nonce( plugin_basename(__FILE__) ).'" />';
		
		switch ( $meta_box['type'] ) {
			
			case 'text':
				echo '<tr><th scope="row" class="labelpadding"><label for="'.$meta_box['name'].'_value">'.$meta_box['title'].'</label></th>';
				echo '<td><input type="text" name="'.$meta_box['name'].'_value" value="'.$meta_box_value.'" size="50" class="medium-text" /><br /><span class="mbdesc">'.$meta_box['description'].'</span></td></tr>';
			break;
			
			case 'textarea':
				echo '<tr><th scope="row" class="labelpadding"><label for="'.$meta_box['name'].'_value">'.$meta_box['title'].'</label></th>';
				echo '<td><textarea name="'.$meta_box['name'].'_value" class="medium-text">'.stripslashes($meta_box_value).'</textarea><br /><span class="mbdesc">'.$meta_box['description'].'</span></td></tr>';
			break;
			
			case 'select':
				echo '<tr><th scope="row"><label for="'.$meta_box['name'].'_value">'.$meta_box['description'].'</label></th>';
				echo'<td><select name="'.$meta_box['name'].'_value" />';
				foreach ($meta_box['options'] as $option) {
					echo'<option';
				
					if ( get_settings( $meta_box['id'] ) == $option) {
						echo ' selected="selected"';
					} elseif ($option == $meta_box['std']) {
						echo ' selected="selected"';
					}
				
					echo '>'.$option.'</option>';
				}
				echo'</select></td></tr>';				
			break;
			
			case "checkbox":
				if(get_post_meta($post->ID, $meta_box['name'].'_value',true) !== "") $checked = "checked=\"checked\""; else $checked = "";
				echo '<tr><th scope="row"><label for="'.$meta_box['name'].'_value">'.$meta_box['title'].'</label></th>';
				echo '<td><input type="checkbox" name="'.$meta_box['name'].'_value" '.$checked.' class="checkbox" /><span class="mbdesc">'.$meta_box['description'].'</span></td></tr>';
			break;		
			
			case "imageupload":
				echo '<tr><th scope="row"><label>'.$meta_box['title'].'</label></th>';
				echo '<td><a class="button thickbox" href="media-upload.php?&amp;type=image&amp;TB_iframe=true" id="add_image" title="Customized Image Upload" onclick="jQuery(this).attr(\'href\',jQuery(this).attr(\'href\').replace(\'\?\',\'?post_id=\'+jQuery(\'#post_ID\').val())); return thickbox(this);">Upload an Image</a></td></tr>';
			break;
			
		} //End Switch
	} // End foreach
	if(!$page) echo '</tbody></table>';
}

function new_post_meta_boxes() {
	new_meta_boxes(false);
}

function new_page_meta_boxes($post) {
	global $new_meta_boxes, $bf_navadmin_settings;
	new_meta_boxes(true);	
	
	foreach($new_meta_boxes as $meta_box) {		
		switch ( $meta_box['type'] ) {
			case "addpage":				
				if (current_user_can( 'edit_page', $post_id )) {
					$nav = get_option(bf_navsort);
					$navItems = explode(',,',$nav);
					$navItems = array_shift($navItems);
					$navItems = explode(',',$navItems);						
					echo'<input type="hidden" name="'.$meta_box['name'].'_noncename" id="'.$meta_box['name'].'_noncename" value="'.wp_create_nonce( plugin_basename(__FILE__) ).'" />';						
					if (in_array($post->post_title, $navItems)) $checked = "checked=\"checked\""; else $checked = "";
					echo '<tr><th scope="row"><label for="'.$meta_box['name'].'_value">'.$meta_box['title'].'</label></th>';
					echo '<td><input type="checkbox" name="'.$meta_box['name'].'_value" '.$checked.' class="checkbox" /><span class="mbdesc">'.$meta_box['description'].'</span></td></tr>';
				}
			break;
		}
	}
	echo '</tbody></table>';
}

function create_meta_box() {
	global $theme_name;
	if ( function_exists('add_meta_box') ) {
		add_meta_box( 'new-meta-boxes', 'Community Innovation Post Settings', 'new_post_meta_boxes', 'post', 'normal', 'high' );
	}
}

function save_postdata( $post_id ) {
	global $new_meta_boxes, $flag;
	
  	if ($flag == 0) {
		foreach($new_meta_boxes as $meta_box) {

			if ( !wp_verify_nonce( $_POST[$meta_box['name'].'_noncename'], plugin_basename(__FILE__) )) {
				return $post_id;
			}
			
			if ( 'page' == $_POST['post_type'] ) {
				if ( !current_user_can( 'edit_page', $post_id ))
				return $post_id;
			} else {
				if ( !current_user_can( 'edit_post', $post_id ))
					return $post_id;
			}
	
			$data = trim($_POST[$meta_box['name'].'_value']);		
			
			
			if ($meta_box['type'] == 'addpage') {			
				if($data == "") { changeNav($post_id, true);}
				elseif ($data !== "") { changeNav($post_id); }
			}
		
			if ($data == "") delete_post_meta($post_id, $meta_box['name'].'_value', get_post_meta($post_id, $meta_box['name'].'_value', true));
			else update_post_meta($post_id, $meta_box['name'].'_value', $data);
		}		
	}
  	$flag = 1;
}

add_action('admin_menu', 'create_meta_box');
add_action('save_post', 'save_postdata');

// Custom attachment option to choose the default image
function default_image_fields_to_edit($form_fields, $post) {
	if ( substr($post->post_mime_type, 0, 5) == 'image' ) {	
		$post_id = $post->ID;
        $meta = wp_get_attachment_metadata( $post_id ); 		
		$defaultImage = $meta['image_meta']['default_image'];		
		
		$form_fields['default_image'] = array(
				'label' => __('Default Image','BigFeature'),
				'input' => 'html',
				'html'  => "
					<input type='radio' name='attachments[$post->ID][default_image]' id='attachments[$post->ID][default_image]' value='yes' ".($defaultImage=='yes'?'checked="checked"':'')." />
					<label for='default_image'>" . __('Yes') . "</label>
					&nbsp; <input type='radio' name='attachments[$post->ID][default_image]' id='attachments[$post->ID][default_image]' value='no' ".($defaultImage!=='yes'?'checked="checked"':'')." />
					<label for='default_image_medium'>" . __('No') . "</label>",
			);
	}      		
	return $form_fields; 
}

function default_image_fields_to_save($post, $attachment) {
	if ( substr($post['post_mime_type'], 0, 5) == 'image' ) {
		$attachment_id = $post['ID'];
		$meta = wp_get_attachment_metadata( $attachment_id );
		$meta['image_meta']['default_image'] = $attachment['default_image'];		
		wp_update_attachment_metadata( $attachment_id, $meta );
	}
	return $post;
} 

add_filter('attachment_fields_to_edit', 'default_image_fields_to_edit', 10, 2);
add_filter('attachment_fields_to_save', 'default_image_fields_to_save', 10, 2);

?>