<?php
class stock_report extends MY_Controller {
	var $base;
	var $css;
	var $js;
	var $third_party;

	function stock_report() {
		parent::MY_Controller();
		$this->base=$this->config->item("base_url");
		$this->css=$this->config->item("cssmain");
		$this->Jscript=$this->config->item("Jscript");
		$this->grid_height=$this->config->item("grid_height");
		$this->third_party=$this->config->item("third_party");		
	}
	function index()
	{
		$data['css']=$this->css;
		$data['base']=$this->base; 
		$data['Jscript']=$this->Jscript;
		//$data['grid_height']=$this->grid_height;	
		$data['third_party']=$this->third_party;
		$this->load->helper('form');	
		$this->load->model('menu','',TRUE);
		$this->load->library('session');
		$this->load->model('buyer_model','',TRUE);
		
		$this->load->model('usermodel','',TRUE);
		$this->load->model('common','',TRUE);
		//$data['work_list']=$this->buyer_model->getWorkServiceList();
		$this->load->model('stockreportmodel','',TRUE);
		
		$range_list=array(
			'0'=>'',
			'today'=>'Today',
			'yday'=>'Yesterday',
			'7days'=>'Last 7 days',
			'15days'=>'Last 15 days',
			'cmonth'=>'Current Month',
			'lmonth'=>'Last Month',
			'cyear'=>'Current year'
		);
		$data['range_list']=$range_list; 
		
		
		
		$select="finid as id,fincode as data";
		$from=" accfinancialyear";
		$condition="";
		$data['finyear']=$this->stockreportmodel->getFinYear();
		
		$data['menustr']=$this->menu->setMenu(0,$data['base']);	
		// session for user integegration===================	
			$userid=$this->session->userdata(HRMS_PREFIX.'userid');
			$userarr=$this->usermodel->getAuthenticationlist($userid,'stock_report','TM');			
			if(!empty($userarr))
			{
			$data['menu_enable']=$userarr['menu_enable'];	
			$data['can_add']=$userarr['can_add'];	
			$data['can_update']=$userarr['can_update'];
			$data['can_delete']=$userarr['can_delete'];	
			}else
			{
			$data['menu_enable']='N';	
			$data['can_add']='N';	
			$data['can_update']='N';
			$data['can_delete']='N';	
			}		
			// session end================================
			//$data['menu_enable']=='Y';					
		$this->load->view("shared/header",$data);
		if($data['menu_enable']=='N')
		{
			$this->load->view('shared/no_permission');
		}else{
			$this->load->view("reports/stock_report");	
		}
		
		$this->load->view("shared/footer");
	}
	
	function fetchStockReport()
	{
		$params['from_date']=date('Y-m-d',strtotime($this->input->post('search_from_date'))); 
		$params['to_date']=date('Y-m-d',strtotime($this->input->post('search_to_date'))); 
		$params['finid']=$this->input->post('finyearid'); 
		$params['itemid']=$this->input->post('searchValueid'); 
		$is_detail1=$this->input->post('is_detail'); 
		
		$this->load->model('stockreportmodel','',TRUE);
		$data=$this->stockreportmodel->fetchStockReport_detail($params);
		
		
		
		
		$from_dt= $this->input->post('search_from_date');
		$to_dt= $this->input->post('search_to_date');
		if(empty($to_dt))
		{
			$to_dt=date('Y-m-d');
		}
		if(empty($from_dt) )
		{
			$str='As On '.date('d-m-Y',strtotime($to_dt)); 
		}
		else{
			$str='From '.date('d-m-Y',strtotime($from_dt)).' To '.date('d-m-Y',strtotime($to_dt)); 
		}
		
		
		$name = "Stock_report.xls";
		header("Content-Type: application/vnd.ms-excel");
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		Header("Content-Disposition: attachment; filename=".$name);
		 	$i=0;
			?>
			<table  border="1" bordercolor="#a6caf0"  bgcolor="white">
<tr  style="background:  #ffffff; text-align: center;"  bordercolor="#000">
<td colspan="9" style='font-weight:bold;font-size:20;color:#008000;'>
Stock Report <?php echo $str; ?>

</td>	
</tr>
<tr></tr>
<tr>
	<th style="font-family: times new roman">Sl No</th>
	<th style="font-family: times new roman">Item Code	</th>
	<th style="font-family: times new roman">Item Name</th>
	<th style="font-family: times new roman">HSN Code</th>
	<th style="font-family: times new roman">Rate</th>
	
	
		<th style="font-family: times new roman">Opening</th>
	<th style="font-family: times new roman">Purchase</th>
	<th style="font-family: times new roman">Sale</th>
	<th style="font-family: times new roman">Adjustment</th>
	<th style="font-family: times new roman">Cur Stock</th>
		
	
		</tr>


<?php

foreach($data as $row){	
					
				$i++;
						
			?>
			<tr>
				<td style="font-family: times new roman"><?php echo $i;?> </td>
				<td style="font-family: times new roman"><?php echo $row['item_code'];?> </td>
				<td style="font-family: times new roman"><?php echo $row['item_name'];?> </td>
				<td style="font-family: times new roman"><?php echo $row['hsn_code'];?> </td>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['rate'];?> </td>
			
				
				<td style="font-family: times new roman;text-align: right"><?php echo $row['Opstock'];?> </td>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['PuQty'];?> </td>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['SLQTY'];?> </td>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['ADJQTYIN'];?> </td>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['curstock'];?> </td>
			
			</tr>
			
			<?php } ?>
			
</table> 	
  

			<?php 	
		} 
		function generatePDF()
		{
		$params['from_date']=date('Y-m-d',strtotime($this->input->post('search_from_date'))); 
		$params['to_date']=date('Y-m-d',strtotime($this->input->post('search_to_date'))); 
		$params['finid']=$this->input->post('finyearid'); 
		$params['itemid']=$this->input->post('searchValueid'); 
		$is_detail1=$this->input->post('is_detail'); 
		
		$this->load->model('stockreportmodel','',TRUE);
		/*if($is_detail1==TRUE)
		{*/
			$data=$this->stockreportmodel->fetchStockReport_detail($params);
		/*}else{
			$data=$this->stockreportmodel->fetchStockReport($params);
		}*/
		 	$i=0;
		 	
			?>
			<table class="responsive-table" width="100%" id="tb_collection_report" align="center" border="1">


<thead>
<tr>
	<th style="font-family: times new roman">Sl No</th>
	<th style="font-family: times new roman">Item Code	</th>
	<th style="font-family: times new roman">Item Name</th>
	<th style="font-family: times new roman">HSN Code</th>
	<th style="font-family: times new roman">Rate</th>
	
	<?php if($is_detail1==TRUE)
		{?>
		<th style="font-family: times new roman">Opening</th>
	<th style="font-family: times new roman">Purchase</th>
	<th style="font-family: times new roman">Sale</th>
	<th style="font-family: times new roman">Adjustment</th>
	<th style="font-family: times new roman">Cur Stock</th>
		<?php }else{?>
		<th style="font-family: times new roman">Quantity</th>
		<?php }?>
	
		</tr>
</thead>
<tbody>
<?php

foreach($data as $row){	
					
				$i++;
						
			?>
			<tr>
				<td style="font-family: times new roman"><?php echo $i;?> </td>
				<td style="font-family: times new roman"><?php echo $row['item_code'];?> </td>
				<td style="font-family: times new roman"><?php echo $row['item_name'];?> </td>
				<td style="font-family: times new roman"><?php echo $row['hsn_code'];?> </td>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['rate'];?> </td>
			
				<?php if($is_detail1==TRUE)
		{?>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['Opstock'];?> </td>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['PuQty'];?> </td>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['SLQTY'];?> </td>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['ADJQTYIN'];?> </td>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['curstock'];?> </td>
			<?php 
			}else{?>
				<td style="font-family: times new roman;text-align: right"><?php echo $row['itemqty'];?> </td>
			
			<?php }}?>
			</tr>
			</tbody>
			
			
</table>   

			<?php 	
		}


	function get_item_list()
			{
			$this->load->model('stockreportmodel','',TRUE);
			$item_code=$_REQUEST['searchValue'];
			//$master_type=$master_type.trim();
			$limit=$_REQUEST['rows'];
			$page=$_REQUEST['page'];
			$count=$this->stockreportmodel->get_item_count($item_code);
			if( $count > 0 && $limit > 0) { 
			$total_pages = ceil($count/$limit); 
			} else { 
			$total_pages = 0; 
			} 
			$details=array();	
			if ($page > $total_pages) $page=$total_pages;			
			$start = $limit*$page - $limit;			
			if($start <0) $start = 0;	
			$echostr='';
			header("Content-type: text/xml;charset=utf-8");
			$echostr = "<?xml version='1.0' encoding='utf-8'?>";
			$echostr.= "<rows>";
			$echostr.= "<page>".$page."</page>";
			$echostr.= "<total>".$total_pages."</total>";
			$echostr.= "<records>".$count."</records>";
			$details=$this->stockreportmodel->getitemList($item_code,$start,$limit);
			 // be sure to put text data in CDATA 
			 foreach($details as $row) 
			 {  
				  $echostr.= "<row>";
				  $echostr.= "<cell>".$row['itemid']."</cell>";
				  $echostr.= "<cell>".$row['item_code']."</cell>";
				 
				  $echostr.= "<cell>".$row['hsn_code']."</cell>";
				   $echostr.= "<cell>".$row['item_name']."</cell>";
				  $echostr.= "<cell>".$row['cgst']."</cell>";
				  $echostr.= "<cell>".$row['sgst']."</cell>";
				  $echostr.= "<cell>".$row['rate']."</cell>";
				  $echostr.= "<cell>".$row['is_active']."</cell>";		  	
				  $echostr.= "</row>"; 
			}
			
			$echostr.= "</rows>"; 
		 	echo $echostr;	
		 	exit();
			}


function getItemDetail()
	{
		$this->load->helper('form');
		$this->load->model('stockreportmodel','',TRUE);		
		$itemid=$_REQUEST['itemid'];
		
		$data=$this->stockreportmodel->getItemDetail($itemid);
		
		
		echo json_encode($data);
		exit();
	}

}





?>