<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "smtp".
 *
 * @property integer $id
 * @property string $host
 * @property string $port
 * @property string $email
 * @property string $password
 * @property integer $office_id
 */
class Smtp extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'smtp';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['host', 'port', 'email', 'password', 'office_id'], 'required'],
            [['office_id','port'], 'integer'],
            [['host'], 'string', 'max' => 255],
             ['email', 'email'],
            [[ 'password'], 'string', 'max' => 200],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'host' => 'Host',
            'port' => 'Port',
            'email' => 'Email',
            'password' => 'Password',
            'office_id' => 'Office ID',
        ];
    }
}
