<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "files".
 *
 * @property integer $id
 * @property string $file_name
 * @property integer $case_id
 * @property integer $office_id
 * @property string $notes
 * @property string $created_on
 * @property integer $added_by
 */
class Files extends \yii\db\ActiveRecord {

    /**
     * @inheritdoc
     */
    public $tempFile;
    public static function tableName() {
        return 'files';
    }

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['file_name', 'case_id', 'office_id', 'created_on', 'added_by'], 'required'],
            [['case_id', 'office_id', 'added_by'], 'integer'],
            [['tempFile'], 'file', 'skipOnEmpty' => false, 'extensions' => 'pdf'],
            [['notes'], 'string'],
            [['created_on'], 'safe'],
            [['file_name'], 'string', 'max' => 500],
            
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'file_name' => 'Name',
            'case_id' => 'Case ID',
            'office_id' => 'Office ID',
            'notes' => 'Notes',
            'created_on' => 'Created On',
            'added_by' => 'Added By',
            'tempFile'=>'File'
        ];
    }

    public function upload() {
        if ($this->validate()) {
            foreach ($this->imageFiles as $file) {
                $file->saveAs('uploads/' . $file->baseName . '.' . $file->extension);
            }
            return true;
        } else {
            return false;
        }
    }

}
