<?php

/* @var $this yii\web\View */

$this->title = 'Dashboard';
?>
<div class="site-index">

<section class="content no-print"> 
				
		<div class="row">	
			<div class="col-md-4">
				<div class="box box-success">
					<div class="box-header with-border">
						<i class="fa fa-bar-chart-o"></i>
						<h3 class="box-title">Case Statistics</h3>
					</div>
					<div class="box-body"><div  style="height:250px" id="donut-chart"></div></div>
				</div>
			</div>		
			
			<div class="col-md-4">
				<div class="box box-success">
					<div class="box-header with-border">
						<i class="fa fa-bar-chart-o"></i>
						<h3 class="box-title">Hearing in next 7 Days</h3>
					</div>
					<div class="box-body"><div  style="height:250px" id="line-chart2" ></div></div>
				</div>
			</div>
			
			
			<div class="col-md-4">			
				<div class="box box-success">
					<div class="box-header with-border">
						<h3 class="box-title">Number of Hearing in next 15 Days</h3>
					</div>
					<div class="box-body">
						<div class="chart" id="bar-chart" style="height:250px"></div>
					</div>		
				</div>
			</div>
		</div>
			
		<div class="row">	
			<div class="col-md-9 xs-12">
				<div class="box box-primary">
					<div class="box-header with-border">
						<i class="fa fa-bar-chart-o"></i>
						<h3 class="box-title">Scheduled Hearing</h3>
					</div>
					<div class="box-body"><div id="calendar"></div></div>
				</div>
			</div>	
				
			<div class="col-lg-3 col-xs-6">				
				<div class="small-box bg-red">
					<div class="inner">
						<h3>0</h3>
						<h4><strong>Total Hearing Today</strong></h4>
					</div>
					<div class="icon"><i class="fa fa-bar-chart-o fa-x"></i></div>	
					<a href="page.php?nav=hearing&amp;date=2017-10-26" class="small-box-footer">View all Hearings Today</a>		
			
				</div>
			</div>
			
			<div class="col-lg-3 col-xs-6">				
				<div class="small-box bg-green">
					<div class="inner">
						<h3>2</h3>
						<h4><strong>Total Cases</strong></h4>
					</div>
					<div class="icon"><i class="fa fa-bar-chart-o fa-x"></i></div>					
				</div>
			</div>
			
			<div class="col-lg-3 col-xs-6">			
				<div class="small-box bg-fuchsia">
					<div class="inner">
						<h3>1</h3>
						<h4><strong>Active Register Cases</strong></h4>
					</div>
					<div class="icon"><i class="fa fa-bar-chart-o fa-fw"></i></div>	
					<a href="page.php?nav=cases" class="small-box-footer">View Active Cases</a>						
				</div>
			</div>
			
			<div class="col-lg-3 col-xs-6">		
				<div class="small-box bg-yellow">
					<div class="inner">
						<h3>1</h3>
						<h4><strong>Disposal Register Cases</strong></h4>
					</div>
					<div class="icon"><i class="fa fa-bar-chart-o fa-fw"></i></div>		
					<a href="page.php?nav=dispose_registry" class="small-box-footer">View Cases in Disposal Register</a>					
				</div>
			</div>
			
<!--
			<div class="col-lg-3 col-xs-6">		
				<div class="small-box bg-aqua">
					<div class="inner">
						<h3>500000.00</h3>
						<h4><strong>Total Earnings (Rs)</strong></h4>
					</div>
					<div class="icon"><i class="fa fa-dollar fa-fw"></i></div>				
					<a href="page.php?nav=earnings" class="small-box-footer">View Earnings</a>					
				</div>
			</div>
-->
						
		</div>
		
</section>

   
<!--cade details   -->
   
<a href="#" data-date="" data-next_hearing="" data-notes="" data-toggle="modal" data-target="#myModal" class="pull-right btn bg-red">Add Case Status</a>   
   

<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"  aria-hidden="true">
	<div class="modal-dialog">	
	
		<div class="box box-primary">
		
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
				<h4><i class="fa fa-bar-chart-o fa-fw"></i>&nbsp;&nbsp;Case Details</h4>
			</div>		
			
			<div class="box-body">
				<form method="post" action="" name="configs1" enctype="multipart/form-data">
						
					<div class="row">
				
						<div class="col-md-6">		
							<div class="form-group">
								<label for="dtp_input1">Next Hearing Date</label>
								<div class="input-group date form_datetime" id="datetimepicker" date-date="31 August 2017 - 11:50" data-date-format="dd MM yyyy - HH:ii" data-link-field="dtp_input1">
									<input class="form-control" name="next_hearing" id="date_time_picker" size="16" type="text" value="" readonly required="required">									
									<span class="input-group-addon"><span class="glyphicon glyphicon-th"></span></span>
								</div>
								<input type="hidden" id="dtp_input1" value="" /><br/>
							</div>	
						</div>			
						
						<div class="col-md-6">				
						<label>Amount Paid</label>		
							<div class="input-group date">
								<div class="input-group-addon"><i class="fa fa-money"></i></div>
								<input type="text" name="amount" id="amount" value="" class="form-control pull-right">
							</div>			
						</div>	
					</div>		
					
					<div class="form-group">
						<label>Current Status</label>							
						<input type="text"  id="current_status" class="form-control" placeholder="Current State of the case" name="status">
					</div>
							
							
							
					<br/>						
					
					<div class="form-group">
						<label>Add/Edit Notes</label>							
						<textarea  id="add_notes" class="form-control" rows='4' name="notes"></textarea>
					</div>
								
					<div class="form-group">
						<label class="control-label">Attach files</label>
						<input id="input-id" name="add_source[]" type="file" multiple class="file-loading">
						<p class="small"><i class="fa fa-clock-o"></i> Max 2MB</p>
					</div>
							
						
					
					<div class="form-group">
						<label class="col-md-4 control-label" for="singlebutton"></label>
						<div class="col-md-6 center-block">			
							<input type="hidden" id="case_id" name="case_id" value="2767">							
							<input type="hidden" id="case_detail_id" name="case_detail_id" value="">
							<input type="hidden" name="case_info" value="1">
							
							<input type="submit" name="save" value="Save" class="btn btn-primary">								
						</div>  
					</div>

				</form>
			</div>
		</div>
	</div>
</div>
      
   
    
</div>
<?php
//$this->registerJsFile("@web/js/all.js",[

$this->registerCssFile("@web/css/fullcalendar.css");

$this->registerJsFile("https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.11.2/moment.min.js",
[
    'depends' => [
        \yii\web\JqueryAsset::className()
    ]
]);

$this->registerJsFile("https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/2.1.1/fullcalendar.min.js",
[
    'depends' => [
        \yii\web\JqueryAsset::className()
    ]
]);


?>



<?php
$script = <<< JS

$('#calendar').fullCalendar({
header: {
        left: 'prev,next today',
        center: 'title',
        right: ''},
	    buttonText: {        
        month: 'month',
        week: 'week'},   
    eventSources: [

        // your event source
        {
            events: [ // put the array in the `events` property
                {
            title  : 'Hearings',
            start  : '2017-10-27',
            end  : '2017-10-27',
            "url":"/hearing"
        },
        
        {
            title  : 'Hearings',
            start  : '2017-10-28',
             end  : '2017-10-28',
            "url":"/hearing"
        }
            ],
            
            "backgroundColor":"#dd43b7",
            "borderColor":"#dd43b7",
        }

        // any other event sources...

    ]

});

    
JS;
$this->registerJs($script);
?>
