<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use common\models\States;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model common\models\Offices */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="login-box clearfix">
    <div class="offices-form">

        <?php $form = ActiveForm::begin(); ?>
        <div class="col-md-12">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>    

        <div class="col-md-12">    
            <?php
            $states = States::find()->where(['country_id' => 101])->asArray()->all();

            $states = ArrayHelper::map($states, 'name', 'name');
            echo $form->field($model, 'state')->widget(Select2::classname(), [
                'data' => $states,
                'options' => ['placeholder' => 'Select State ...'],
                'pluginOptions' => [
                    'allowClear' => true
                ]
            ]);
            ?>
        </div>    
        <div class="col-md-12">    
            <?= $form->field($model, 'district')->textInput(['maxlength' => true]) ?>
        </div>    
       
        <div class="col-md-12">
            <?= $form->field($model, 'address')->textarea(['rows' => 6]) ?>
        </div>   
        <div class="form-group col-md-12">
            <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Get Started', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary f-right']) ?>
        </div>

        <?php ActiveForm::end(); ?>

    </div>
</div><!-- /.login-box -->
