<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\HearingsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Hearings';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="hearings-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Hearings', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    <?=
    GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'id',
            'case_id',
            ['attribute' => 'next_appearing_date', 'value' => function($data) {
                    return ($data->hearing_date != '0000-00-00') ? date('d-m-Y', strtotime($data->hearing_date)) : '-';
                },],
//            'hearing_date',
            'amount_paid',
            'description:ntext',
            // 'office_id',
            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]);
    ?>
</div>
