<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\ClientsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Clients';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="clients-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Clients', ['create'], ['class' => 'btn btn-success']); 
            if (!$resetButton) {
            $url = (isset($_GET['id'])) ? '/clients?id=' . $_GET['id'] : '/clients'
            ?>
            <?php echo Html::a('Reset Filter', [$url], ['class' => 'btn btn-info']); ?><br>
    <?php } ?>
    </p>
    <?=
    GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
//            'id',
            'name',
            'address:ntext',
            'phone',
            'email:email',
            ['label' => 'Cases',
                'format' => 'raw',
                'value' => function ($data) {
                    return Html::a(Html::encode("View"), '@web/cases?client=' . $data['id']);
                }],
            // 'status',
             ['class' => 'yii\grid\ActionColumn',
                'header' => 'Actions',
                'template' => '{update} {delete}',],
        ],
    ]);
    ?>
</div>
