<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/* @var $this yii\web\View */
/* @var $model common\models\Cases */
/* @var $form yii\widgets\ActiveForm */
?>


<?php $form = ActiveForm::begin([
'id' => 'form-id',
'enableAjaxValidation' => false,
]
); ?>
<?php
echo $form->field($model, 'hearing_date')->widget(DatePicker::classname(), [
    'options' => ['placeholder' => ''],
    'pluginOptions' => [
        'format' => 'yyyy-mm-dd',
        'autoclose' => true,
        'todayHighlight' => true,
        'endDate'=>($case)?$case->next_appearing_date:false
    ]
]);
?>
<?= $form->field($model, 'description')->textarea(['rows' => 3]) ?>

<div class="form-group">
    <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
</div>

<?php ActiveForm::end(); ?>

