<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use common\models\Clients;
use common\models\ClientType;
use common\models\CaseType;
use common\models\Court;
use yii\helpers\ArrayHelper;
use common\models\OpponentType;
use kartik\date\DatePicker;
use common\models\User;
/* @var $this yii\web\View */
/* @var $model common\models\Cases */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="cases-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class="col-lg-4">
        <?php
        if ($model->isNewRecord) {
            $ClientType = ClientType::find()->where(['status' => 1, 'office_id' => Yii::$app->user->identity->office_id])->orWhere(['status' => 1, 'office_id' => 0])->asArray()->all();
        } else {
            $ClientType = ClientType::find()->where(['office_id' => Yii::$app->user->identity->office_id])->orWhere(['status' => 1, 'office_id' => 0])->asArray()->all();
        }
        $ClientType = ArrayHelper::map($ClientType, 'id', 'type');
        echo $form->field($model, 'client_type')->widget(Select2::classname(), [
            'data' => $ClientType,
            'options' => ['placeholder' => 'Select a Client Type ...'],
            'pluginOptions' => [
                'allowClear' => true
            ]
        ]);
        ?>
    </div>
    <div class="col-lg-8">
        <?php
        if ($model->isNewRecord) {
            $ClientName = Clients::find()->where(['status' => 1, 'office_id' => Yii::$app->user->identity->office_id])->asArray()->all();
        } else {
            $ClientName = Clients::find()->where(['office_id' => Yii::$app->user->identity->office_id])->asArray()->all();
        }
        $ClientName = ArrayHelper::map($ClientName, 'id', 'name');
        echo $form->field($model, 'client_name')->widget(Select2::classname(), [
            'data' => $ClientName,
            'options' => ['placeholder' => 'Select a Client Name ...', 'multiple' => true,],
            'pluginOptions' => [
                'allowClear' => true,
                'tags' => false
            ]
        ]);
        ?>
    </div>
    <div class="col-lg-4">
        <?php
        if ($model->isNewRecord) {
            $opponentType = ClientType::find()->where(['status' => 1, 'office_id' => Yii::$app->user->identity->office_id])->orWhere(['status' => 1, 'office_id' => 0])->asArray()->all();
        } else {
            $opponentType = ClientType::find()->where(['office_id' => Yii::$app->user->identity->office_id])->orWhere(['status' => 1, 'office_id' => 0])->asArray()->all();
        }
        $opponentType = ArrayHelper::map($opponentType, 'id', 'type');
        echo $form->field($model, 'opponent_type')->widget(Select2::classname(), [
            'data' => $opponentType,
            'options' => ['placeholder' => 'Select a Opponent Type ...'],
            'pluginOptions' => [
                'allowClear' => true
            ]
        ]);
        ?>
    </div>
     
    <div class="col-lg-8">
        <?= $form->field($model, 'opponent_name')->textInput(['maxlength' => true]) ?>
    </div>
    <div class="col-lg-4">
        <?= $form->field($model, 'case_number')->textInput(['maxlength' => true]) ?>
    </div>
    <div class="col-lg-4">
        <?php
        if ($model->isNewRecord) {
            $opponentType = CaseType::find()->where(['status' => 1, 'office_id' => Yii::$app->user->identity->office_id])->orWhere(['status' => 1, 'office_id' => 0])->asArray()->all();
        } else {
            $opponentType = CaseType::find()->where(['office_id' => Yii::$app->user->identity->office_id])->orWhere(['status' => 1, 'office_id' => 0])->asArray()->all();
        }
        $opponentType = ArrayHelper::map($opponentType, 'id', 'type');
        echo $form->field($model, 'case_type')->widget(Select2::classname(), [
            'data' => $opponentType,
            'options' => ['placeholder' => 'Select a Opponent Type ...'],
            'pluginOptions' => [
                'allowClear' => true
            ]
        ]);
        ?>
    </div>
    <div class="col-lg-4">
        <?php
        if ($model->isNewRecord) {
            $advocate = User::find()->where(['status' => 1, 'office_id' => Yii::$app->user->identity->office_id,'role'=>User::ROLE_ADMIN])->orWhere(['status' => 1, 'office_id' => Yii::$app->user->identity->office_id,'role'=>User::ROLE_ADVOCATE])->asArray()->all();
        } else {
            $advocate = User::find()->where(['office_id' => Yii::$app->user->identity->office_id,'role'=>User::ROLE_ADMIN])->orWhere(['office_id' => Yii::$app->user->identity->office_id,'role'=>User::ROLE_ADVOCATE])->asArray()->all();
        }
        $advocate = ArrayHelper::map($advocate, 'first_name', 'first_name');
        echo $form->field($model, 'appeared_by')->widget(Select2::classname(), [
            'data' => $advocate,
            'options' => ['placeholder' => 'Select Advocate ...'],
            'pluginOptions' => [
                'allowClear' => true
            ]
        ]);
        ?>
    </div>
    <div class="col-lg-4">
        <?php
        echo $form->field($model, 'case_register_date')->widget(DatePicker::classname(), [
            'options' => ['placeholder' => ''],
            'pluginOptions' => [
                'format' => 'yyyy-mm-dd',
                'autoclose' => true,
                'todayHighlight' => true,
            ]
        ]);
        ?>
    </div>
    <div class="col-lg-4">
        <?php
        if ($model->isNewRecord) {
            $CourtName = Court::find()->where(['status' => 1, 'office_id' => Yii::$app->user->identity->office_id])->orderBy('court_name')->asArray()->all();
        } else {
            $CourtName = Court::find()->where(['office_id' => Yii::$app->user->identity->office_id])->asArray()->all();
        }
        $CourtName = ArrayHelper::map($CourtName, 'id', 'court_name');
        echo $form->field($model, 'court_name')->widget(Select2::classname(), [
            'data' => $CourtName,
            'options' => ['placeholder' => 'Select a Court Name ...'],
            'pluginOptions' => [
                'allowClear' => true
            ]
        ]);
        ?>

    </div>
    <div class="col-lg-12">
        <?= $form->field($model, 'case_details')->textarea(['rows' => 6]) ?>
    </div>





    <div class="form-group col-lg-12">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
