<?php

namespace backend\controllers;

use Yii;
use common\models\Transactions;
use common\models\SmsPlans;
use common\models\TransactionsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\models\Offices;
use common\components\Helper;

/**
 * SmsPurchaseHistoryController implements the CRUD actions for Transactions model.
 */
class TransactionsController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
    
    /**
     * if not logged in redirect to login page
     */
    public function beforeAction($action) {

        Yii::$app->user->setReturnUrl(Yii::$app->request->getUrl());
        if (Yii::$app->user->isGuest && $this->id != "site") {
            return $this->redirect(Yii::$app->getUrlManager()->getBaseUrl() . '/login ', 302)->send();
        }
        return true;
    }

    /**
     * Lists all Transactions models.
     * @return mixed
     */
    public function actionIndex() {
        $officeDetails = Offices::find()
                ->where('id = :id', [':id' => Yii::$app->user->identity->office_id])
                ->one();

        
        $purchaseHistory = Transactions::getPurchaseHistory(Yii::$app->user->identity->office_id);


        $smsPlans = SmsPlans::find()->where(['status' => 1])->asArray()->all();

        return $this->render('purchase-history', [

                    'purchaseHistory' => $purchaseHistory,
                    'smsPlans' => $smsPlans,
                    'officeDetails' => $officeDetails
        ]);
    }

    /**
     * Displays a single Transactions model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Transactions model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new Transactions();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Transactions model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Transactions model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id) {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Transactions model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Transactions the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = Transactions::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionPaymentSuccess() {
        $result = $_REQUEST;

        $model = Transactions::find()
                ->where('request_id = :request_id', [':request_id' => $result['payment_request_id']])
                ->one();

        $model->transaction_status = 'Success';
        $model->transaction_id = $result['payment_id'];
        $model->item = 'sms';
        $model->save();
        $planDetails = SmsPlans::find()
                ->where('id = :id', [':id' => $model->package_id])
                ->one();

        $officeDetails = Offices::find()
                ->where('id = :id', [':id' => $model->office_id])
                ->one();
     
        $officeDetails->remaining_sms=$officeDetails->remaining_sms+$planDetails->sms_count;
        $officeDetails->save();

        Yii::$app->session->setFlash('success', 'Your Payment is Success');
        return $this->redirect(['index']);
    }

}
