<?php
/* @var $this \yii\web\View */
/* @var $content string */
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;
AppAsset::register($this);
if (Yii::$app->controller->action->id != 'index') {
$inner="inner";    
}
else
{
   $inner=""; 
}
?>
    <?php $this->beginPage() ?>
        <!DOCTYPE html>
        <html lang="<?= Yii::$app->language ?>">

        <head>
            <?= Html::csrfMetaTags() ?>
                <meta charset="<?= Yii::$app->charset ?>">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <meta name=keyword content="Court Diary, Advocate Diary, Case Diary">
                <meta name="description" content="">
                <meta name="author" content="">
                <!-- Mobile Stuff -->
                <meta http-equiv="X-UA-Compatible" content="IE=edge">
                <meta name="viewport" content="width=device-width, initial-scale=1">
                <meta name="msapplication-tap-highlight" content="no">
                <!-- Chrome on Android -->
                <meta name="mobile-web-app-capable" content="yes">
                <meta name="application-name" content="Court Diary">
                <link rel="icon" sizes="192x192" href="<?= Yii::$app->request->baseUrl ?>/images/touch/chrome-touch-icon.png">
                <!-- Safari on iOS -->
                <meta name="apple-mobile-web-app-capable" content="yes">
                <meta name="apple-mobile-web-app-status-bar-style" content="black">
                <meta name="apple-mobile-web-app-title" content="Suexcel">
                <link rel="apple-touch-icon" href="<?= Yii::$app->request->baseUrl ?>/images/touch/apple-touch-icon.png">
                <!-- Windows 8 -->
                <meta name="msapplication-TileImage" content="<?= Yii::$app->request->baseUrl ?>/images/touch/ms-touch-icon.png">
                <meta name="msapplication-TileColor" content="#FFF">
                <meta name="theme-color" content="#000">
                <link rel="shortcut icon" href="<?= Yii::$app->request->baseUrl ?>/img/fav.ico">
                <link href="https://fonts.googleapis.com/css?family=Muli:300,400,600,700,800,900" rel="stylesheet">
                <?= Html::csrfMetaTags() ?>
                    <title>
                        <?= Html::encode($this->title) ?>
                    </title>
                    <?php $this->head() ?>
        </head>

        <body>
            <?php $this->beginBody() ?>
                <div class="view <?= $inner;?>">
                    <header>
                        <div class="header-wrap cf">
                            <div class="container">
                                <div class="header-bottom-panel cf">
                                    <div class="logo pull-left"> <a href="../"> <img src="<?= Yii::$app->request->baseUrl ?>/img/case-dairy.png" alt="Court Dairy"> </a> </div> <a class="menu-icon pull-right" href="#"><span class="">Menu</span><i class="ion-android-menu"></i></a>
                                    <div class="menu-panel cf">
                                        <nav class="nav-menu">
                                            <div class="menu-logo"> <a href="../"> <img src="<?= Yii::$app->request->baseUrl ?>/img/case-dairy.png" alt="Court Diary"> </a> </div>
                                            <ul>
                                                <li><a href="#">Features</a></li>
<!--                                                <li><a href="#">Pricing</a></li>-->
                                                <li><a href="#">Testimonials</a></li>
                                                <li><a href="#">Contact</a></li>
                                                <li><a href="/cd-admin" class="login">Login</a></li>
                                            </ul>
                                        </nav>
                                    </div>
                                    <div class="overlay"></div>
                                </div>
                            </div>
                        </div>
                    </header>
                    <div id="main">
                        <?= Alert::widget() ?>
                            <?= $content ?>
                    </div>
                </div>
                <footer class="footer">
                    <div class="container">
                        <div class="col-md-3">
                            <div class="social clearfix"> <a href="#"><i class="fa fa-facebook"></i></a> <a href="#"><i class="fa fa-twitter"></i></a> <a href="#"><i class="fa fa-linkedin"></i></a> </div>
                        </div>
                        <div class="col-md-5">
                            <div class="store">
                                <div class="applestore"><img src="<?= Yii::$app->request->baseUrl ?>/img/apple-store.jpg" alt="Court Dairy Apple Store"></div>
                                <div class="palystore"><img src="<?= Yii::$app->request->baseUrl ?>/img/play-store.jpg" alt="Court Dairy play Store"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <ul class="social-link">
                                <li><a href="#">Privacy Policy </a> <span class="seprator"> | </span><a href="#">Terms & Conditions</a></li>                                
                            </ul>
                            <span class="copyrights">© <?= date("Y");?> Court Diary. All Rights Reserved.</span> 
                        </div>
                    </div>
                </footer>
                <?php $this->endBody() ?>
        </body>
        <script>
            $(document).ready(function () {
                Metronic.init();
            });
        </script>

        </html>
        <?php $this->endPage() ?>