<?php

namespace frontend\controllers;

use Yii;
use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\models\LoginForm;
use frontend\models\PasswordResetRequestForm;
use frontend\models\ResetPasswordForm;
use frontend\models\SignupForm;
use frontend\models\ContactForm;
use common\models\Plans;
use common\models\UserSignup;
use common\models\Offices;
use common\components\Helper;

/**
 * Site controller
 */
class SiteController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout', 'signup'],
                'rules' => [
                    [
                        'actions' => ['signup'],
                        'allow' => true,
                        'roles' => ['?'],
                    ],
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return mixed
     */
    public function actionIndex() {
        $plans = Plans::findAll(['status' => 1]);
        return $this->render('index', ['plans' => $plans]);
    }

    /**
     * Logs in a user.
     *
     * @return mixed
     */
    public function actionLogin() {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->goBack();
        } else {
            return $this->render('login', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Logs out the current user.
     *
     * @return mixed
     */
    public function actionLogout() {
        Yii::$app->user->logout();

        return $this->goHome();
    }

    /**
     * Displays contact page.
     *
     * @return mixed
     */
    public function actionContact() {
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail(Yii::$app->params['adminEmail'])) {
                Yii::$app->session->setFlash('success', 'Thank you for contacting us. We will respond to you as soon as possible.');
            } else {
                Yii::$app->session->setFlash('error', 'There was an error sending email.');
            }

            return $this->refresh();
        } else {
            return $this->render('contact', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Displays about page.
     *
     * @return mixed
     */
    public function actionAbout() {
        return $this->render('about');
    }

    /**
     * Signs user up.
     *
     * @return mixed
     */
     public function actionRegisterSuccess() {
        return $this->render('RegisterSuccess');
    }
    
    public function actionSignup() {
        $model = new UserSignup();
        $model1 = new Offices();
        $plan = (Yii::$app->request->post('plan', null)) ? Yii::$app->request->post('plan', null) : Yii::$app->session->get('plan');
        if (!$plan) {
            return $this->goHome();
        }
        Yii::$app->session->set('plan', $plan);
        $tempPass = 'CD' . rand(1000, 9999);
        $planDetails = Plans::findOne(['id' => $plan]);
        $model1->plan = $planDetails->id;
        $model1->plan_expiry = date('Y-m-d', strtotime("+" . $planDetails->trail_period . " days"));
        $model->role = UserSignup::ROLE_ADMIN;
        $model->password = $tempPass;
        $model->password_hash = $tempPass;
        $model->password_repeat = $tempPass;
//        stop($model);
//        stop(Yii::$app->request->queryParams['type']);
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            $data = Yii::$app->request->post();
//            stop($data);
            $model->first_name = $data['UserSignup']['first_name'];
            $model->last_name = $data['UserSignup']['last_name'];
            $model->email = $data['UserSignup']['email'];
            $model->username = $data['UserSignup']['email'];
            $model->created_on = date('Y-m-d H:i:s');
            $model->status = UserSignup::STATUS_ACTIVE;
            $model->phone = $data['UserSignup']['phone'];
            $model->setPassword($tempPass);
            $model->generateAuthKey();

            if ($model->save()) {

                $model1->name = '';
                $model1->remaining_sms = ($planDetails->sms_count>0)?$planDetails->sms_count:Yii::$app->params['free_sms_count'];
                if ($model1->save()) {
                    $model->office_id = $model1->id;
                    $model->password_reset_token = $model->generatePasswordResetToken();
                    $model->save();
                    $to = $model->email;
//                    $subject = '[CASE DAIRY]- Confirm Email';
//                    $templateData['name'] = $model->first_name . ' ' . $model->last_name;
//                    $templateData['link'] = Yii::$app->urlManager->createAbsoluteUrl(['/site/verify-account', 'token' => $model->password_reset_token]);
//                    $file = 'verifyAccount';
//                    Helper::sendMail($to, $subject, $templateData, $file);
                    $message = Yii::$app->params['signup_message'];
                    $params = array('temp' => $tempPass);
                    Helper::sendPublicMessage($message, $params,  $model->phone);
                    Yii::$app->session->remove('plan');
//                    Yii::$app->session->setFlash('success', 'User added successfully!');
                } else {
                    Yii::$app->session->setFlash('error', 'Unable to create user, Please try again');
                }
            } else {
                Yii::$app->session->setFlash('error', 'Unable to create user, Please try again');
            }
            return $this->render('RegisterSuccess');
//            $this->redirect('/register-success');
//            return $this->goHome();
        }
        return $this->render('signup', [
                    'model' => $model,
        ]);
    }

    /**
     * Requests password reset.
     *
     * @return mixed
     */
    public function actionRequestPasswordReset() {
        $model = new PasswordResetRequestForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail()) {
                Yii::$app->session->setFlash('success', 'Check your email for further instructions.');

                return $this->goHome();
            } else {
                Yii::$app->session->setFlash('error', 'Sorry, we are unable to reset password for email provided.');
            }
        }

        return $this->render('requestPasswordResetToken', [
                    'model' => $model,
        ]);
    }

    /**
     * Resets password.
     *
     * @param string $token
     * @return mixed
     * @throws BadRequestHttpException
     */
    public function actionVerifyAccount($token) {

        try {
            $model = new ResetPasswordForm($token);
        } catch (InvalidParamException $e) {
            throw new BadRequestHttpException($e->getMessage());
        }

        if ($model->load(Yii::$app->request->post()) && $model->validate() && $model->resetPassword()) {
            Yii::$app->session->setFlash('success', 'New password was saved.');

            return $this->goHome();
        }

        return $this->render('resetPassword', [
                    'model' => $model,
        ]);
    }

    /**
     * Resets password.
     *
     * @param string $token
     * @return mixed
     * @throws BadRequestHttpException
     */
    public function actionResetPassword($token) {

        try {
            $model = new ResetPasswordForm($token);
        } catch (InvalidParamException $e) {
            throw new BadRequestHttpException($e->getMessage());
        }

        if ($model->load(Yii::$app->request->post()) && $model->validate() && $model->resetPassword()) {
            Yii::$app->session->setFlash('success', 'New password was saved.');
            return $this->redirect(Yii::$app->urlManagerFrontEnd->createUrl(['site/index']));
        }

        return $this->render('resetPassword', [
                    'model' => $model,
        ]);
    }

}
