<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "sms_log".
 *
 * @property integer $id
 * @property integer $office_id
 * @property integer $phone
 * @property string $message
 * @property string $sent_on
 * @property string $status
 */
class SmsLog extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'sms_log';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'office_id', 'phone', 'message', 'sent_on', 'status'], 'required'],
            [['id', 'office_id', 'phone'], 'integer'],
            [['message', 'status'], 'string'],
            [['sent_on'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'office_id' => 'Office ID',
            'phone' => 'Phone',
            'message' => 'Message',
            'sent_on' => 'Sent On',
            'status' => 'Status',
        ];
    }
}
