<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "hearings".
 *
 * @property integer $id
 * @property string $case_id
 * @property string $hearing_date
 * @property string $amount_paid
 * @property string $description
 * @property integer $office_id
 */
class Hearings extends \yii\db\ActiveRecord {

    /**
     * @inheritdoc
     */
    public static function tableName() {
        return 'hearings';
    }

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['case_id', 'hearing_date', 'description', 'office_id'], 'required'],
            [['hearing_date'], 'safe'],
            [['description'], 'string'],
            [['office_id'], 'integer'],
            [['case_id', 'amount_paid'], 'string', 'max' => 200],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'case_id' => 'Case ID',
            'hearing_date' => 'Hearing Date',
            'amount_paid' => 'Amount Paid',
            'description' => 'Description',
            'office_id' => 'Office ID',
        ];
    }

    public static function getCaseHearingDate($office_id) {
        $caseCount = self::find()
                ->select(['COUNT(*) AS cnt', 'hearing_date'])
                ->where('office_id = ' . $office_id)
                ->groupBy(['hearing_date']);
//        stop($caseCount->createCommand()->getRawSql());
        $result = $caseCount->asArray()->all();
        return $result;
    }

}
