<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "court".
 *
 * @property integer $id
 * @property string $court_name
 * @property string $description
 * @property integer $office_id
 */
class Court extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'court';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['court_name', 'office_id'], 'required'],
            [['office_id'], 'integer'],
            [['court_name', 'description'], 'string', 'max' => 200],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'court_name' => 'Court Name',
            'description' => 'Description',
            'office_id' => 'Office ID',
        ];
    }
}
