<?php

namespace common\models;

use Yii;
use common\models\User;
use common\models\Clients;
use common\models\ClientType;
use common\models\CaseType;

use common\models\OpponentType;
use common\models\Court;
use yii\db\Query;

/**
 * This is the model class for table "cases".
 *
 * @property integer $id
 * @property string $case_number
 * @property string $case_details
 * @property string $created_on
 * @property integer $created_by
 * @property string $appeared_by
 * @property string $next_appearing_date
 * @property integer $status
 * @property integer $office_id
 * @property integer $client_type
 * @property integer $client_name
 * @property integer $opponent_type
 * @property integer $opponent_name
 */
class Cases extends \yii\db\ActiveRecord {

    /**
     * @inheritdoc
     */
    public static function tableName() {
        return 'cases';
    }

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['case_number'], 'unique'],
            [['case_number', 'case_details', 'created_on', 'created_by', 'appeared_by', 'case_register_date', 'status', 'office_id', 'client_type', 'client_name', 'court_name', 'opponent_type', 'opponent_name','case_type'], 'required'],
            [['case_details'], 'string'],
            [['created_on', 'case_register_date', 'next_appearing_date'], 'safe'],
            [['created_by', 'status', 'office_id', 'client_type', 'opponent_type', 'court_name','list'], 'integer'],
            [['case_number', 'appeared_by', 'opponent_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'case_number' => 'Case Number',
            'case_details' => 'Case Details',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
            'appeared_by' => 'Appeared By',
            'case_register_date' => 'Register Date',
            'status' => 'Status',
            'court_name' => 'Court Name',
            'office_id' => 'Office ID',
            'client_type' => 'Client Type',
            'client_name' => 'Client Name',
            'opponent_type' => 'Opponent Type',
            'opponent_name' => 'Opponent Name',
            'next_appearing_date' => 'Next Hearing Date',
            'case_type'=>'Case Type'
        ];
    }

    public static function getclientName($clients) {
        $caseCount = Clients::find()
                ->select(['*'])
                ->where('id IN ('.implode(',', $clients).')');
        $result = $caseCount->asArray()->all();
        return $result;

    }

    public function getclientType() {
        return $this->hasOne(ClientType::className(), ['id' => 'client_type']);
    }
public function getcaseType() {
        return $this->hasOne(CaseType::className(), ['id' => 'case_type']);
    }


    public function getcourt() {
        return $this->hasOne(Court::className(), ['id' => 'court_name']);
    }

    public function getcreatedBy() {
        return $this->hasOne(User::className(), ['id' => 'created_by']);
    }

    public static function getCaseCountWithStatus($office_id) {
        $caseCount = self::find()
                ->select(['COUNT(*) AS cnt', 'status'])
                ->where('office_id = ' . $office_id)
                ->groupBy(['status']);
//        stop($caseCount->createCommand()->getRawSql());
        $result = $caseCount->asArray()->all();
        return $result;
    }

    public static function getCaseCountWithDate($office_id) {
        $caseCount = self::find()
                ->select(['COUNT(*) AS cnt', 'next_appearing_date'])
                ->where('office_id = ' . $office_id)
                ->andWhere('status = 1')
                ->groupBy(['next_appearing_date']);
//        stop($caseCount->createCommand()->getRawSql());
        $result = $caseCount->asArray()->all();
        return $result;
    }

    public static function getHearingCountNextDays($office_id,$days) {
        $caseCount = self::find()
                ->select(['COUNT(*) AS cnt', 'next_appearing_date'])
                ->where('office_id = ' . $office_id)
                ->andWhere('`next_appearing_date` BETWEEN NOW() AND DATE_ADD(NOW(), INTERVAL '.$days.' DAY)')
                ->groupBy(['next_appearing_date']);
//        stop($caseCount->createCommand()->getRawSql());
        $result = $caseCount->asArray()->all();
        return $result;
    }
    public static function getHearingCountToday($office_id) {
        $caseCount = self::find()
                ->select(['COUNT(*) AS cnt'])
                ->where('office_id = ' . $office_id)
                ->andWhere('DATE(next_appearing_date) = CURDATE()');
//        stop($caseCount->createCommand()->getRawSql());
        $result = $caseCount->asArray()->one();
        return $result;
    }

    public static function getCaseDetails($id) {
        $query = new Query;
        $query->select([
                    'cases.*',
                    'offices.remaining_sms', 'offices.sms_sender_id']
                )
                ->from('cases')
                ->join('LEFT JOIN', 'offices', 'cases.office_id =offices.id')
                ->where('cases.id=' . $id);

        $command = $query->createCommand();
        $data = $command->queryAll();
        return ($data) ? (object) $data[0] : null;
    }
     public static function getUnupdatedCount($office_id) {
        $caseCount = self::find()
                ->select(['COUNT(*) AS cnt'])
                ->where('office_id = ' . $office_id)
                ->andWhere('DATE(next_appearing_date) < CURDATE()');
//        stop($caseCount->createCommand()->getRawSql());
        $result = $caseCount->asArray()->one();
        return $result;
    }

}
