<?php
use yii\helpers\Url;
/* @var $this yii\web\View */

$this->title = 'Dashboard';
?>
    <div class="site-index">
        <div class="row">
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box"> <span class="info-box-icon bg-violet"><i class="fa fa-gavel"></i></span>
                    <div class="info-box-content"> <span class="info-box-text">Total Cases</span> <span class="info-box-number"><?php echo $disposalCases+$activeCases; ?></span> </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box"> <span class="info-box-icon bg-violet-light"><i class="fa fa-list-ul"></i></span>
                    <div class="info-box-content"> <span class="info-box-text">LIST CASES</span> <span class="info-box-number">90</span> </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box"> <span class="info-box-icon bg-skyblue"><i class="fa fa-refresh"></i></span>
                    <div class="info-box-content"> <span class="info-box-text">UN UPDATED CASES</span> <span class="info-box-number"><?php echo $unUpdatedCase['cnt']; ?></span> </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box"> <span class="info-box-icon bg-grey"><i class="fa fa-gavel"></i></span>
                    <div class="info-box-content"> <span class="info-box-text">Total Clients</span> <span class="info-box-number"><?= $totalClients['cnt']; ?></span> </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="box box-violet">
                    <div class="box-header with-border"> <i class="fa fa-bar-chart-o"></i>
                        <h3 class="box-title">Case Statistics</h3> </div>
                    <div class="box-body">
                        <div style="height:250px" id="donut-chart"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="box violet-light">
                    <div class="box-header with-border"> <i class="fa fa-bar-chart-o"></i>
                        <h3 class="box-title">Hearing in next 7 Days</h3> </div>
                    <div class="box-body">
                        <div style="height:250px" id="line-chart2"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="box skyblue">
                    <div class="box-header with-border">
                        <h3 class="box-title">Number of Hearing in next 15 Days</h3> </div>
                    <div class="box-body">
                        <div class="chart" id="bar-chart" style="height:250px"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-8 xs-12">
                <div class="box white">
                    <div class="box-header with-border"> <i class="fa fa-bar-chart-o"></i>
                        <h3 class="box-title">Scheduled Hearing</h3> </div>
                    <div class="box-body">
                        <div id="calendar"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box bg-violet">
                    <div class="infobox-content">
                    <h2>Total <br>Hearing Today <span class="info-box-number"><?php echo (isset($hearingsToday['cnt']))?$hearingsToday['cnt']:0; ?></span></h2>
                      <span class="info-box-text"><a href="<?php echo Url::to(['cases/', 'CasesSearch' => array('next_appearing_date' => date('Y-m-d') . ' - ' . date('Y-m-d'))]) ?>"><i class="fa fa-arrow-circle-right"></i></a></span> </div>
                </div>
            </div>
            
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box bg-violet-light">
                    <div class="infobox-content">
                    <h2>Total <br>Hearing Tomorrow <span class="info-box-number"><?php echo (isset($hearingsTomorrow['cnt']) && $hearingsTomorrow['cnt']>0)?$hearingsTomorrow['cnt']:0; ?></span></h2>
                      <span class="info-box-text"><a href="<?php echo Url::to(['cases/', 'CasesSearch' => array('next_appearing_date' =>(isset($hearingsTomorrow['next_appearing_date']))? $hearingsTomorrow['next_appearing_date'] . ' - ' . $hearingsTomorrow['next_appearing_date']:'')]) ?>"><i class="fa fa-arrow-circle-right"></i></a></span> </div>
                </div>
            </div>
            
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box bg-skyblue">
                    <div class="infobox-content">
                    <h2>Active <br>Register Cases <span class="info-box-number"><?php echo $activeCases; ?></span></h2>
                      <span class="info-box-text"><a href="<?php echo Url::to(['cases/']) ?>"><i class="fa fa-arrow-circle-right"></i></a></span> </div>
                </div>
            </div>
            
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="info-box bg-grey">
                    <div class="infobox-content">
                    <h2>Disposal <br>Register Cases <span class="info-box-number"><?php echo $disposalCases; ?></span></h2>
                      <span class="info-box-text"><a href="<?php echo Url::to(['cases/disposal-cases']) ?>"><i class="fa fa-arrow-circle-right"></i></a></span> </div>
                </div>
            </div>
            
            
<!--
            <div class="col-lg-4 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo (isset($hearingsToday['cnt']))?$hearingsToday['cnt']:0; ?></h3>
                        <h4><strong>Total Hearing Today</strong></h4> </div>
                    <div class="icon"><i class="fa fa-bar-chart-o fa-x"></i></div> <a href="<?php echo Url::to(['cases/', 'CasesSearch' => array('next_appearing_date' => date('Y-m-d') . ' - ' . date('Y-m-d'))]) ?>" class="small-box-footer">View all Hearings Today</a> </div>
            </div>

            <div class="col-lg-4 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo (isset($hearingsTomorrow['cnt']) && $hearingsTomorrow['cnt']>0)?$hearingsTomorrow['cnt']:0; ?></h3>
                        <h4><strong>Total Hearing Tomorrow</strong></h4> </div>
                    <div class="icon"><i class="fa fa-bar-chart-o fa-fw"></i> </div> <a href="<?php echo Url::to(['cases/', 'CasesSearch' => array('next_appearing_date' =>(isset($hearingsTomorrow['next_appearing_date']))? $hearingsTomorrow['next_appearing_date'] . ' - ' . $hearingsTomorrow['next_appearing_date']:'')]) ?>" class="small-box-footer">View All Tomorrow's Hearings</a> </div>
            </div>
            <div class="col-lg-4 col-xs-6">
                <div class="small-box bg-fuchsia">
                    <div class="inner">
                        <h3><?php echo $activeCases; ?></h3>
                        <h4><strong>Active Register Cases</strong></h4> </div>
                    <div class="icon"><i class="fa fa-bar-chart-o fa-fw"></i></div> <a href="<?php echo Url::to(['cases/']) ?>" class="small-box-footer">View Active Cases</a> </div>
            </div>
            <div class="col-lg-4 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo $disposalCases; ?></h3>
                        <h4><strong>Disposal Register Cases</strong></h4> </div>
                    <div class="icon"><i class="fa fa-bar-chart-o fa-fw"></i></div> <a href="<?php echo Url::to(['cases/disposal-cases']) ?>" class="small-box-footer">View Cases in Disposal Register</a> </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                    <div class="small-box bg-green">
                        <div class="inner">
                            <h3><?php echo $disposalCases+$activeCases; ?></h3>
                            <h4><strong>Total Cases</strong></h4> </div>
                        <div class="icon"><i class="fa fa-bar-chart-o fa-x"></i></div>
                    </div>
                </div>
                
			<div class="col-lg-3 col-xs-6">		
				<div class="small-box bg-aqua">
					<div class="inner">
						<h3>500000.00</h3>
						<h4><strong>Total Earnings (Rs)</strong></h4>
					</div>
					<div class="icon"><i class="fa fa-dollar fa-fw"></i></div>				
					<a href="page.php?nav=earnings" class="small-box-footer">View Earnings</a>					
				</div>
			</div>
--></div>
        <!--cade details   -->
    </div>
    <?php
//$this->registerJsFile("@web/js/all.js",[

$this->registerCssFile("@web/css/fullcalendar.css");

$this->registerJsFile("@web/js/raphael-min.js",['depends' => [ \yii\web\JqueryAsset::className()]]);
$this->registerJsFile("@web/js/morris.min.js",['depends' => [ \yii\web\JqueryAsset::className()]]);
$this->registerJsFile("@web/js/dashboard.js",['depends' => [ \yii\web\JqueryAsset::className()]]);


$this->registerJsFile("https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.11.2/moment.min.js",['depends' => [ \yii\web\JqueryAsset::className()]]);
$this->registerJsFile("https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/2.1.1/fullcalendar.min.js",['depends' => [\yii\web\JqueryAsset::className()]]);


?>
        <?php
$script = <<< JS
    
JS;
$this->registerJs($script);
?>