<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\grid\GridView;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model common\models\Cases */

$this->title = $model->case_number;
$this->params['breadcrumbs'][] = ['label' => 'Cases', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="cases-view">

<!--    <h1><?= Html::encode($this->title) ?></h1>-->

    <!--
        <p>
    <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
    <?=
    Html::a('Delete', ['delete', 'id' => $model->id], [
        'class' => 'btn btn-danger',
        'data' => [
            'confirm' => 'Are you sure you want to delete this item?',
            'method' => 'post',
        ],
    ])
    ?>
           
        </p>
    -->


    <div class="col-md-4">
        <div class="box ">
            <div class="box-body box-profile">
                <?php if ($model->status != 0) { ?>
                    <?= Html::a('<i class="fa fa-edit fa-2x"></i>', ['update', 'id' => $model->id], ['class' => 'pull-right btn-box-tool']) ?>
                                            <!--<a href="/update/" title="Edit Case Detail" class="pull-right btn-box-tool"><i class="fa fa-edit fa-2x"></i></a>-->
                <?php } ?>
                <img class="profile-user-img img-responsive img-circle" src="<?= @web ?>/../../img/avatar04.png" alt="User profile picture">


                <ul class="list-group list-group-unbordered">
                    <li class="list-group-item"><b>Case ID</b> <a class="pull-right"><?= Html::encode($this->title) ?></a></li>

                    <li class="list-group-item"><b>Opponent</b> <a href="" class="pull-right"><?= $model->opponent_name ?></a></li>						

                    <!--						<li class="list-group-item"><b>Lawyer (Firm)</b><a class="pull-right"> Office Name</a></li>				  -->
                    <li class="list-group-item"><b>Court</b><a class="pull-right"><?= $model->court->court_name ?></a></li>				  
                </ul>
            </div>
        </div>
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-map-marker margin-r-5"></i>Clients</h3>
            </div>
            <div class="box-body">
                <?php foreach ($model->getclientName(json_decode($model->client_name)) as $key => $value) {
                    ?>
                    <ul>
                        <li ><i class="fa fa-user fa-fw"></i><?= $value['name'] ?></li>
                        <li ><i class="fa fa-envelope fa-fw"></i><?= $value['email'] ?></li>
                        <li ><i class="fa fa-phone fa-fw"></i><?= $value['phone'] ?></li>
                    </ul>

                <?php }
                ?>

            </div>
        </div>
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-map-marker margin-r-5"></i>Additional Information</h3>
            </div>
            <div class="box-body">
                <p class="text-muted"><?= $model->case_details ?></p>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <?php if ($model->status != 0) { ?>
            <a class="btn btn-sm btn-info popupModal" href="hearing/<?php echo $model->id ?>"> Add Hearings</a>
        <?php } ?>
        <h2>Hearing Details</h2>
        <?=
        GridView::widget([
            'dataProvider' => $dataProvider,
            'filterModel' => $searchModel,
            'columns' => [
                ['class' => 'yii\grid\SerialColumn'],
//            'id',
                ['attribute' => 'hearing_date',
                    'value' => function($data) {
                        return ($data->hearing_date != '0000-00-00') ? date('d-m-Y', strtotime($data->hearing_date)) : '-';
                    },
                    'filter' => false,],
                ['attribute' => 'description',
                    'filter' => false,],
//            'transaction_id',
                ['class' => 'yii\grid\ActionColumn',
                    'header' => 'Actions',
                    'visible' => $model->status,
                    'template' => '{leadUpdate} {leadDelete}',
                    'buttons' => [
                        'leadUpdate' => function ($url, $model) {
                            $url = Url::to(['hearings/update', 'id' => $model->id]);
                            return Html::a('<span class="fa fa-pencil"></span>', $url, ['title' => 'update', 'class' => 'popupModal']);
                        },
                                'leadDelete' => function ($url, $model) {
                            $url = Url::to(['hearings/delete', 'id' => $model->id]);
                            return Html::a('<span class="fa fa-trash"></span>', $url, [
                                        'title' => 'delete',
                                        'data-confirm' => Yii::t('yii', 'Are you sure you want to delete this item?'),
                                        'data-method' => 'post',
                            ]);
                        },
                            ]
                        ],
                    ],
                ]);
                ?>
            </div>
<!--
            <div class="col-md-8">
                <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]) ?>

                <?= $form->field($files, 'tempFile')->fileInput() ?>
                <?= $form->field($files, 'notes')->textarea(['rows' => 4]) ?>

                <button>Submit</button>

                <?php ActiveForm::end() ?>
                <?=
                GridView::widget([
                    'dataProvider' => $fileDataProvider,
                    'filterModel' => $fileSearchModel,
                    'columns' => [
                        ['class' => 'yii\grid\SerialColumn'],
//                        'id',
                        'file_name',
                        'notes',
//                        'office_id',
                        [
                            'class' => 'yii\grid\ActionColumn',
                            'header' => 'Actions',
                            'headerOptions' => ['style' => 'color:#337ab7'],
                            'template' => '{delete_file}',
                            'buttons' => [

                                'delete_file' => function ($url, $model) {
                                    return Html::a('<span class="glyphicon glyphicon-trash"></span>', $url, [
                                                'title' => Yii::t('app', 'Delete'),
                                    ]);
                                }
                                    ],
                                    'urlCreator' => function ($action, $model, $key, $index) {
                                if ($action === 'delete_file') {
                                    $url = 'deletefile/' . $model->id;
                                    return $url;
                                }
                            }
                                ],
                            ],
                        ]);
                        ?>
                    </div>
-->
                </div>
                <?php
                yii\bootstrap\Modal::begin([
                    'header' => '<h2>Update Hearing</h2>',
                    'headerOptions' => ['id' => 'modalHeader'],
                    'id' => 'modal',
                    'size' => 'modal-lg',
                    'clientOptions' => ['backdrop' => 'static', 'keyboard' => FALSE]
                ]);
                ?>
                <div id='modalContent'>
                    <div class="modal-loader-content">
                        <i class="fa fa-spinner fa-pulse fa-3x fa-fw modal-loader"></i>
                    </div>   
                </div>
                <?php yii\bootstrap\Modal::end(); ?>
                <?php
                $this->registerJs("$(function() {
   $('.popupModal').click(function(e) {
     e.preventDefault();
     $('#modal').modal('show').find('#modalContent')
     .load($(this).attr('href'));
   });
});");
                ?>