<?php

namespace backend\controllers;

use Yii;
use app\models\User;
use common\models\Offices;
use app\models\UserSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\components\AccessRule;
use yii\filters\AccessControl;
use common\components\Helper;

/**
 * UserController implements the CRUD actions for User model.
 */
class StaffController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'ruleConfig' => [
                    'class' => AccessRule::className()
                ],
                'only' => [
                    'index',
                    'create',
                    'update',
                    'delete',
                    'statusupdate'
                ],
                'rules' => Yii::$app->Roleprocessor->getPermission('User')
            ]
        ];
    }

    /**
     * if not logged in redirect to login page
     */
    public function beforeAction() {

        Yii::$app->user->setReturnUrl(Yii::$app->request->getUrl());
        if (Yii::$app->user->isGuest && $this->id != "site") {
            return $this->redirect(Yii::$app->getUrlManager()->getBaseUrl() . '/login ', 302)->send();
        }
        return true;
    }

    /**
     * Lists all User models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new UserSearch();
        $searchModel->office_id = Yii::$app->user->identity->office_id;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $resetButton = (count(Yii::$app->request->queryParams) > 0) ? false : true;

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
                    'resetButton' => $resetButton,
        ]);
    }

    /**
     * Displays a single User model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new User model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new User ();
        $model->scenario = 'create-user';
        $model1 = new Offices();
        $model->office_id = Yii::$app->user->identity->office_id;
//        stop(Yii::$app->request->queryParams['type']);
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
           
            $tempPass = 'CD' . rand(1000, 9999);
            $data = Yii::$app->request->post();
            $model->email = $data['User']['email'];
            $model->username = $data['User']['email'];
            $model->created_on = date('Y-m-d H:i:s');
            $model->status = User::STATUS_ACTIVE;
             $model->role = $data['User']['role'];

            $model->setPassword($tempPass);
            $model->generateAuthKey();
            if ($model->save()) {
                $officeDetails = Offices::find()
                        ->where('id = :id', [':id' => Yii::$app->user->identity->office_id])
                        ->one();
                $message = Yii::$app->params['staff_added'];
                $params = array('office_name' => $officeDetails->name, 'phone' => $model->phone, 'password' => $tempPass);
                Helper::sendCommonMessage($officeDetails, $message, $params, $model->phone);
                Yii::$app->session->setFlash('success', 'Staff added successfully!');
            } else {
                Yii::$app->session->setFlash('error', 'Unable to create Staff');
            }
            return $this->redirect(['index']);
        } else {
//            stop($model->getErrors());
            return $this->render('create', [
                        'model' => $model,
                        'params' => Yii::$app->request->queryParams
            ]);
        }
    }

    /**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            $data = Yii::$app->request->post();
            $model->email = $data['User']['email'];
            $model->username = $data['User']['email'];
            if ($model->save()) {
                Yii::$app->session->setFlash('success', 'Staff updated successfully!');
            } else {
                Yii::$app->session->setFlash('error', 'Unable to update Staff details');
            }
            return $this->redirect(['index']);
        } else {
            return $this->render('update', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing User model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id) {
        $model = $this->findModel($id);
        $model->scenario = 'create-user';
        $status = User::STATUS_DELETED;
        $model->status = $status;
        $model->save();
        Yii::$app->session->setFlash('success', 'User deleted successfully!');
        return $this->redirect(['index']);
    }

    /**
     * Finds the User model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return User the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = User::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionStatusupdate($id) {

        $model = $this->findModel($id);
        $status = ($model->status == 1) ? User::STATUS_DEACTIVE : User::STATUS_ACTIVE;
        $model->status = $status;
        $model->save();
        Yii::$app->session->setFlash('success', 'Status changed successfully!');
        return $this->redirect(Yii::$app->request->referrer);
    }

}
