<?php

namespace backend\controllers;

use Yii;
use common\models\Hearings;
use common\models\Cases;
use common\models\HearingsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\components\Helper;

/**
 * HearingsController implements the CRUD actions for Hearings model.
 */
class HearingsController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * if not logged in redirect to login page
     */
    public function beforeAction() {

        Yii::$app->user->setReturnUrl(Yii::$app->request->getUrl());
        if (Yii::$app->user->isGuest && $this->id != "site") {
            return $this->redirect(Yii::$app->getUrlManager()->getBaseUrl() . '/login ', 302)->send();
        }
        return true;
    }
    /**
     * Lists all Hearings models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new HearingsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Hearings model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Hearings model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new Hearings();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Hearings model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $case = Cases::find()->where(['id' => $model->case_id])->One();
//           pre($hearingDate);
        if (Yii::$app->request->post()){
            if ($model->load(Yii::$app->request->post())) {


                $oldHearing = $this->findModel($id);
                $hearingDate = ($case->next_appearing_date == $oldHearing->hearing_date) ? $oldHearing->hearing_date : "";

                if ($model->save()) {
                    if ($hearingDate != '') {
                        $case->next_appearing_date = $model->hearing_date;
                        if ($case->save()) {
                            $message = Yii::$app->params['hearing_date_updated'];
                            $params = array('date' => date('l jS \of F Y',  strtotime($case->next_appearing_date)), 'case_id' => $case->case_number, 'advocate' => Yii::$app->user->identity->first_name . ' ' . Yii::$app->user->identity->last_name);
                            Helper::sendMessage($case->id, $message, $params);
                        }
                    }
                    if (Yii::$app->request->isAjax) {
                        Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
                        return ['success' => true];
                    }
                    return $this->redirect(['cases/view', 'id' => $model->case_id]);
                } else {
                    if (Yii::$app->request->isAjax) {
                        Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
                        stop(\yii\widgets\ActiveForm::validate($model));
                        return \yii\widgets\ActiveForm::validate($model);
                    }
                }
            }
        }
        if (Yii::$app->request->isAjax) {
            return $this->renderAjax('/cases/hearing', [
                        'model' => $model, 'case' => $case
            ]);
        }
    }

    /**
     * Deletes an existing Hearings model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id) {
        $this->findModel($id)->delete();
        return $this->redirect(Yii::$app->request->referrer);
    }

    /**
     * Finds the Hearings model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Hearings the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = Hearings::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
