<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "clients".
 *
 * @property integer $id
 * @property string $name
 * @property string $address
 * @property integer $phone
 * @property string $email
 * @property integer $status
 * @property integer $office_id
 */
class Clients extends \yii\db\ActiveRecord {

    /**
     * @inheritdoc
     */
    public static function tableName() {
        return 'clients';
    }

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['name', 'phone','address'], 'required'],
            [['address'], 'string'],
            [['phone', 'status', 'client_type','office_id'], 'integer'],
            [['name', 'email'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'address' => 'Address',
            'phone' => 'Phone',
            'email' => 'Email',
            'client_type' => 'Client Type',
            'status' => 'Status',
        ];
    }

}
