<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace common\components;

use Yii;
use common\models\Cases;
use common\models\Offices;
use Instamojo\Instamojo;

/**
 * Description of Helper
 *
 * @author HEAVENS
 */
class Helper {

    public static function sendMessage($case_id, $message, $params = array(), $mobile = null) {

        $username = "heavens";
        $api_password = "45c48fk2aibgbxsf1";
        $domain = "sms.heavens.co.in";
        $priority = "11"; // 11-Enterprise, 12- Scrub
        $method = "POST";
        $sender = 'HWSTCR';

        if (COUNT($params)) {
            foreach ($params as $key => $value) {
                $message = str_replace('{' . $key . '}', $value, $message);
            }
        }


        $office = Cases::getCaseDetails($case_id);
        $clients = Cases::getclientName(json_decode($office->client_name));
        if ($clients) {
            $smsCount = ceil(strlen($message) / 160) * COUNT($clients);
            if ($mobile == null) {
                $mobile = '';
                foreach ($clients as $keys => $values) {
                    if ($mobile != '') {
                        $mobile .=',';
                    }
                    $mobile .=$values['phone'];
                }
            }
            if ($office && $office->remaining_sms >= $smsCount) {

                $sender = ($office->sms_sender_id != '') ? $office->sms_sender_id : $sender;
                $username = urlencode($username);
                $password = urlencode($api_password);
                $sender = urlencode($sender);
                $message = urlencode($message);

                $parameters = "username=$username&api_password=$password&sender=$sender&to=$mobile&message=$message&priority=$priority";

                $url = "http://$domain/pushsms.php";

                $ch = curl_init($url);

                if ($method == "POST") {
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $parameters);
                } else {
                    $get_url = $url . "?" . $parameters;

                    curl_setopt($ch, CURLOPT_POST, 0);
                    curl_setopt($ch, CURLOPT_URL, $get_url);
                }

                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
                curl_setopt($ch, CURLOPT_HEADER, 0);  // DO NOT RETURN HTTP HEADERS 
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);  // RETURN THE CONTENTS OF THE CALL
                $return_val = curl_exec($ch);


                if ($return_val == "") {
                    return false;
                } else {
                    $office = Offices::find()->where(['id' => $office->office_id])->one();
                    $office->remaining_sms = ($office->remaining_sms - $smsCount);
                    $office->save();
                    return true;
                }
            }
        }
    }

    public static function sendCommonMessage($office, $message, $params = array(), $mobile = null) {

        $username = "heavens";
        $api_password = "45c48fk2aibgbxsf1";
        $domain = "sms.heavens.co.in";
        $priority = "11"; // 11-Enterprise, 12- Scrub
        $method = "POST";
        $sender = 'HWSTCR';

        if (COUNT($params)) {
            foreach ($params as $key => $value) {
                $message = str_replace('{' . $key . '}', $value, $message);
            }
        }
        $smsCount = ceil(strlen($message) / 160);
        if ($office && $office->remaining_sms >= $smsCount) {

            $sender = ($office->sms_sender_id != '') ? $office->sms_sender_id : $sender;
            $username = urlencode($username);
            $password = urlencode($api_password);
            $sender = urlencode($sender);
            $message = urlencode($message);

            $parameters = "username=$username&api_password=$password&sender=$sender&to=$mobile&message=$message&priority=$priority";

            $url = "http://$domain/pushsms.php";

            $ch = curl_init($url);

            if ($method == "POST") {
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $parameters);
            } else {
                $get_url = $url . "?" . $parameters;

                curl_setopt($ch, CURLOPT_POST, 0);
                curl_setopt($ch, CURLOPT_URL, $get_url);
            }

            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_HEADER, 0);  // DO NOT RETURN HTTP HEADERS 
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);  // RETURN THE CONTENTS OF THE CALL
            $return_val = curl_exec($ch);

            if ($return_val == "") {
                return false;
            } else {
                $office = Offices::find()->where(['id' => $office->id])->one();
                $office->remaining_sms = ($office->remaining_sms - $smsCount);
                $office->save();
                return true;
            }
        }
    }

    public static function payment($planDetails, $officeDetails) {
        $api = new Instamojo(Yii::$app->params['instamojo_api_key'], Yii::$app->params['instamojo_api_token']);
        try {
            $response = $api->paymentRequestCreate(array(
                "purpose" => "SMS plan- " . $planDetails->plan_name,
                "amount" => $planDetails->price,
                "buyer_name" => $officeDetails->name,
                "send_email" => false,
                "send_sms" => false,
                "redirect_url" => Yii::$app->urlManager->createAbsoluteUrl('sms-purchase-history/payment-success')
            ));

            return $response;
        } catch (Exception $e) {
            return false;
        }
    }

    public static function getDays($range) {
        $date = date('Y-m-d'); //today date
        $weekOfdays = array();
        for ($i = 1; $i <= $range; $i++) {
            $date = date('Y-m-d', strtotime('+1 day', strtotime($date)));
            $weekOfdays[] = date('Y-m-d', strtotime($date));
        }
        return $weekOfdays;
    }
    public static function sendMail($to, $subject, $templateData, $file) {
        $from = array(Yii::$app->params['from_mail'] => 'Law New');
        $message = Yii::$app->mailer->compose($file, ['params' => $templateData])
                ->setFrom($from)
                ->setTo($to)
                ->setSubject($subject)
                ->setTextBody('Plain text content')
//                    ->setHtmlBody($template)
                ->send();
//        stop($message);
    }

}
