<?php

namespace backend\controllers;

use Yii;
use common\models\Opponents;
use common\models\OpponentsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * OpponentsController implements the CRUD actions for Opponents model.
 */
class OpponentsController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * if not logged in redirect to login page
     */
    public function beforeAction($action) {
        Yii::$app->user->setReturnUrl(Yii::$app->request->getUrl());
        if (Yii::$app->user->isGuest && $this->id != "site")
            $this->redirect(['/site/login']);
        return true;
    }

    /**
     * Lists all Opponents models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new OpponentsSearch();
        $searchModel->status = 1;
        $searchModel->office_id = Yii::$app->user->identity->office_id;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $resetButton = (count(Yii::$app->request->queryParams) > 0) ? false : true;

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
                    'resetButton' => $resetButton,
        ]);
    }

    /**
     * Displays a single Opponents model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Opponents model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new Opponents();
        $model->status = 1;
        $model->office_id = Yii::$app->user->identity->office_id;
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Opponent added successfully!');
            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Opponents model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Opponent updated successfully!');
            return $this->redirect(['index']);
        } else {
            return $this->render('update', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Opponents model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id) {
        $model = $this->findModel($id);
        $status = 0;
        $model->status = $status;
        Yii::$app->session->setFlash('success', 'Opponent Deleted successfully!');
        $model->save();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Opponents model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Opponents the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = Opponents::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
