<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\SmsPurchaseHistory;

/**
 * SmsPurchaseHistorySearch represents the model behind the search form about `common\models\SmsPurchaseHistory`.
 */
class SmsPurchaseHistorySearch extends SmsPurchaseHistory
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'package_id', 'office_id'], 'integer'],
            [['date', 'transaction_id', 'transaction_status', 'payment_mode'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = SmsPurchaseHistory::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'package_id' => $this->package_id,
            'date' => $this->date,
            'office_id' => $this->office_id,
        ]);

        $query->andFilterWhere(['like', 'transaction_id', $this->transaction_id])
            ->andFilterWhere(['like', 'transaction_status', $this->transaction_status])
            ->andFilterWhere(['like', 'payment_mode', $this->payment_mode]);

        return $dataProvider;
    }
}
