<?php

/**
 * Manage Permission for backend user
 *
 * @author Shalini
 */

namespace common\components;

use Yii;
use yii\base\Component;
use common\models\User;

class Roleprocessor extends Component {

    public function getPermission($contoller) {

        $permission = array(
            'User' => [
                'index' => [
                    User::ROLE_SUPER_ADMIN
                ],
                'create' => [
                    User::ROLE_SUPER_ADMIN
                ],
                'update' => [
                    User::ROLE_SUPER_ADMIN
                ],
                'delete' => [
                    User::ROLE_SUPER_ADMIN
                ]
            ],
            'Cases' => [
                'index' => [
                    User::ROLE_ADMIN
                ],
                'create' => [
                    User::ROLE_ADMIN
                ],
                'update' => [
                    User::ROLE_ADMIN
                ],
                'delete' => [
                    User::ROLE_ADMIN
                ]
            ]
        );
        $cont = $permission [$contoller];
        $array = [
            [
                'actions' => [
                    'index'
                ],
                'allow' => true,
                // Allow users admins to create
                'roles' => $cont ['create']
            ],
            [
                'actions' => [
                    'create'
                ],
                'allow' => true,
                // Allow users admins to create
                'roles' => $cont ['create']
            ],
            [
                'actions' => [
                    'update'
                ],
                'allow' => true,
                // Allow users admin and moderator to update
                'roles' => $cont ['update']
            ],
            [
                'actions' => [
                    'delete'
                ],
                'allow' => true,
                // Allow users admin to delete
                'roles' => $cont ['delete']
            ]
        ];
 	
        return $array;
    }

}
