<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\models\User;

/* @var $this yii\web\View */
/* @var $model app\models\User */
/* @var $model1 app\models\Offices */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="user-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'first_name')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'last_name')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'phone')->textInput(['maxlength' => true]) ?>
    <?php if ($model->isNewRecord) { ?>
        <?= $form->field($model, 'password_hash')->textInput(['maxlength' => true]) ?>
    <?php } ?>
        <?= $form->field($model, 'role')->dropDownList([User::ROLE_ADVOCATE => 'Advocate', User::ROLE_STAFF => 'Staff'], ['prompt' => 'Select Status']) ?>
    <div class="form-group">
<?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

<?php ActiveForm::end(); ?>

</div>
