<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "sms_plans".
 *
 * @property integer $id
 * @property string $plan_name
 * @property integer $sms_count
 * @property integer $price
 * @property integer $status
 */
class SmsPlans extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'sms_plans';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['plan_name', 'sms_count', 'price', 'status'], 'required'],
            [['sms_count', 'price', 'status'], 'integer'],
            [['plan_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'plan_name' => 'Plan Name',
            'sms_count' => 'Sms Count',
            'price' => 'Price',
            'status' => 'Status',
        ];
    }
}
