<?php

namespace backend\controllers;

use Yii;
use common\models\Cases;
use common\models\Hearings;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\components\AccessRule;
use yii\filters\AccessControl;
use yii\helpers\Url;
use common\components\Helper;

/**
 * ClientsController implements the CRUD actions for Clients model.
 */
class DashboardController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'ruleConfig' => [
                    'class' => AccessRule::className()
                ],
                'only' => [
                    'index',
                    'create',
                    'update',
                    'delete',
                    'disposalCases',
                    'earingsCalender',
                    'hearingsLineChart'
                ],
                'rules' => Yii::$app->Roleprocessor->getPermission('User')
            ]
        ];
    }

    /**
     * if not logged in redirect to login page
     */
    public function beforeAction($action) {

        Yii::$app->user->setReturnUrl(Yii::$app->request->getUrl());
        if (Yii::$app->user->isGuest && $this->id != "site") {
            $this->redirect(['site/login']);
        }
        return true;
    }

    /**
     * Lists all Clients models.
     * @return mixed
     */
    public function actionIndex() {
        $office_id = Yii::$app->user->identity->office_id;
        $caseStatusCount = Cases::getCaseCountWithStatus($office_id);
//        $hearingdate = Hearings::getCaseHearingDate($office_id);

        $caseStatus = array();
        $activeCases = 0;
        $disposalCases = 0;
        foreach ($caseStatusCount as $key => $value) {
            if ($value['status'] == 1) {
                $activeCases = $value['cnt'];
            } else {
                $disposalCases = $value['cnt'];
            }
            $data['label'] = ($value['status'] == 0) ? 'Disposal' : 'Active';
            $data['value'] = $value['cnt'];
            array_push($caseStatus, $data);
        }
        $caseStatus = json_encode($caseStatus, JSON_NUMERIC_CHECK);
        $hearingsToday = Cases::getHearingCountToday($office_id);
        $hearingsTomorrow = Cases::getHearingCountNextDays($office_id, 1);
        $hearingsTomorrow = ($hearingsTomorrow) ? $hearingsTomorrow[0] : array();
        return $this->render('index', [
                    'caseStatus' => $caseStatus, 'disposalCases' => $disposalCases, 'activeCases' => $activeCases, 'hearingsToday' => $hearingsToday, 'hearingsTomorrow' => $hearingsTomorrow
        ]);
    }

    public function actionTotalcases() {
//      stop('asdas');
        $office_id = Yii::$app->user->identity->office_id;
        $caseStatusCount = Cases::getCaseCountWithStatus($office_id);
        //stop($hearingdate);
        $caseStatus = array();
        if ($caseStatusCount) {
            foreach ($caseStatusCount as $key => $value) {
                $data['label'] = ($value['status'] == 0) ? 'Disposal' : 'Active';
                $data['value'] = $value['cnt'];
                array_push($caseStatus, $data);
            }
        } else {
            $data['label'] = 'Active';
            $data['value'] = 0;
            array_push($caseStatus, $data);
        }
        echo $caseStatus = json_encode($caseStatus, JSON_NUMERIC_CHECK);
//         stop($caseStatus);
    }

    public function actionHearingsCalender() {
//      stop('asdas');
        $office_id = Yii::$app->user->identity->office_id;
        $caseStatusCount = Cases::getCaseCountWithDate($office_id);
        $hearingDate = array();
        foreach ($caseStatusCount as $key => $value) {
            $data['id'] = $key;
            $data['resourceId'] = $key;
            $data['start'] = $value['next_appearing_date'];
            $data['end'] = $value['next_appearing_date'];
            $data['title'] = ($value['cnt'] > 1) ? $value['cnt'] . ' Hearings' : $value['cnt'] . ' Hearing';
            $data['backgroundColor'] = '#7f73d6';
            $data['borderColor'] = '#7f73d6';
            $data['url'] = Url::to(['cases/', 'CasesSearch' => array('next_appearing_date' => $value['next_appearing_date'] . ' - ' . $value['next_appearing_date'])]);
            array_push($hearingDate, $data);
        }
        echo $hearingDate = json_encode($hearingDate, JSON_NUMERIC_CHECK);
//         stop($caseStatus);
    }

//For Next 7 Days
    public function actionHearingsLineChart() {
//      stop('asdas');
        $office_id = Yii::$app->user->identity->office_id;
        $caseStatusCount = Cases::getHearingCountNextDays($office_id, 7);
        
        $days = Helper::getDays(7);
        $hearingDate = array();
        $availableDate = array();
        foreach ($caseStatusCount as $k => $v) {
            array_push($availableDate, $v['next_appearing_date']);
        }
            foreach ($days as $keys => $value) {
                $key = array_search($value, $availableDate);
                $data['date'] = $value;
                $data['hearing'] = (($key >= 0) && isset($caseStatusCount[$key]) && ($value == $caseStatusCount[$key]['next_appearing_date'])) ? $caseStatusCount[$key]['cnt'] : 0;
                array_push($hearingDate, $data);
            }
        echo $hearingDate = json_encode($hearingDate, JSON_NUMERIC_CHECK);

    }

//    For next 15 Days

    public function actionHearingsBarChart() {
//      stop('asdas');
        $office_id = Yii::$app->user->identity->office_id;
        $caseStatusCount = Cases::getHearingCountNextDays($office_id, 15);

        $days = Helper::getDays(15);
        $hearingDate = array();
        $availableDate = array();

        foreach ($caseStatusCount as $k => $v) {
            array_push($availableDate, $v['next_appearing_date']);
        }
//stop($caseStatusCount);
        foreach ($days as $keys => $value) {
            $key = array_search($value, $availableDate);
            $data['y'] = $value;
            $data['a'] = (($key >= 0) && isset($caseStatusCount[$key]) && ($value == $caseStatusCount[$key]['next_appearing_date'])) ? $caseStatusCount[$key]['cnt'] : 0;
            array_push($hearingDate, $data);
        }

        echo $hearingDate = json_encode($hearingDate, JSON_NUMERIC_CHECK);
//         stop($caseStatus);
    }

}
