<?php

namespace backend\controllers;

use Yii;
use common\models\Cases;
use common\models\Files;
use common\models\FilesSearch;
use common\models\Hearings;
use common\models\CasesSearch;
use common\models\HearingsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\components\AccessRule;
use yii\filters\AccessControl;
use common\components\Helper;
use yii\web\UploadedFile;

/**
 * CasesController implements the CRUD actions for Cases model.
 */
class CasesController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'ruleConfig' => [
                    'class' => AccessRule::className()
                ],
                'only' => [
                    'index',
                    'create',
                    'update',
                    'delete',
                    'statusupdate',
                    'hearing',
                    'list',
                    'addtolist',
                ],
                'rules' => Yii::$app->Roleprocessor->getPermission('Cases')
            ]
        ];
    }

    /**
     * if not logged in redirect to login page
     */
    public function beforeAction($action) {
        Yii::$app->user->setReturnUrl(Yii::$app->request->getUrl());
        if (Yii::$app->user->isGuest && $this->id != "site")
            $this->redirect(['/site/login']);
        return true;
    }

    /**
     * Lists all Cases models.
     * @return mixed
     */
    public function actionIndex() {
        $title = 'Active Cases';
        $disposal = false;
        $data = Yii::$app->request->queryParams;
        $searchModel = new CasesSearch();
        $searchModel->office_id = Yii::$app->user->identity->office_id;
        $client = false;
//        if (isset($data['client']) && $data['client'] > 0) {
//            $searchModel->client_name = $data['client'];
//            $client = true;
//        }

        $searchModel->status = 1;
//         stop($searchModel);
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        IF (isset($data['client'])) {
            $resetButton = (count($data) > 1) ? false : true;
        } else {
            $resetButton = (count($data) > 0) ? false : true;
        }

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
                    'resetButton' => $resetButton,
                    'client' => $client, 'title' => $title, 'disposal' => $disposal
        ]);
    }

    /**
     * Lists all Cases models.
     * @return mixed
     */
    public function actionDisposalCases() {
        $title = 'Disposal Cases';
        $disposal = true;
        $data = Yii::$app->request->queryParams;
        $searchModel = new CasesSearch();
        $searchModel->office_id = Yii::$app->user->identity->office_id;
        $client = true;

        $searchModel->status = 0;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        IF (isset($data['client'])) {
            $resetButton = (count($data) > 1) ? false : true;
        } else {
            $resetButton = (count($data) > 0) ? false : true;
        }

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
                    'resetButton' => $resetButton,
                    'client' => $client,
                    'title' => $title, 'disposal' => $disposal
        ]);
    }

    /**
     * Lists all Cases models.
     * @return mixed
     */
    public function actionListCases() {
        $title = 'List Cases';
        $disposal = false;
        $data = Yii::$app->request->queryParams;
        $searchModel = new CasesSearch();
        $searchModel->office_id = Yii::$app->user->identity->office_id;
        $client = false;
//        if (isset($data['client']) && $data['client'] > 0) {
//            $searchModel->client_name = $data['client'];
//            $client = true;
//        }
        $searchModel->list = 1;
        $searchModel->status = 1;
//         stop($searchModel);
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        IF (isset($data['client'])) {
            $resetButton = (count($data) > 1) ? false : true;
        } else {
            $resetButton = (count($data) > 0) ? false : true;
        }

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
                    'resetButton' => $resetButton,
                    'client' => $client, 'title' => $title, 'disposal' => $disposal
        ]);
    }

    /**
     * Lists all Cases models.
     * @return mixed
     */
    public function actionPendingUpdates() {
        $title = 'Hearing Updates Pending';
        $disposal = false;
        $data = Yii::$app->request->queryParams;
        $searchModel = new CasesSearch();
        $searchModel->office_id = Yii::$app->user->identity->office_id;
        $client = false;
//        if (isset($data['client']) && $data['client'] > 0) {
//            $searchModel->client_name = $data['client'];
//            $client = true;
//        }

        $searchModel->status = 1;
        $searchModel->next_appearing_date = '1970-01-01  ' . date('Y-m-d', strtotime("-1 days"));
//         stop($searchModel);
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        IF (isset($data['client'])) {
            $resetButton = (count($data) > 1) ? false : true;
        } else {
            $resetButton = (count($data) > 0) ? false : true;
        }

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
                    'resetButton' => $resetButton,
                    'client' => $client, 'title' => $title, 'disposal' => $disposal
        ]);
    }

    /**
     * Displays a single Cases model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id) {
        $searchModel = new HearingsSearch();
        $searchModel->office_id = Yii::$app->user->identity->office_id;
        $searchModel->case_id = $id;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $files = new Files();
        $files->office_id = Yii::$app->user->identity->office_id;
        $files->case_id = $id;
        $files->created_on = date('Y-m-d');
        $files->added_by = Yii::$app->user->identity->id;
        $fileSearchModel = new FilesSearch();
        $fileSearchModel->case_id = $id;
        $fileDataProvider = $fileSearchModel->search(Yii::$app->request->queryParams);

        if (Yii::$app->request->isPost) {
            $files->load(Yii::$app->request->post());
//        stop($_FILES);

            $uploadedFile = UploadedFile::getInstance($files, 'tempFile');
            $name = md5(date('Y-m-d H:i:s:u')) . "." . $uploadedFile->extension;
            $uploadFolder = Yii::getAlias('@common') . '/../upload/' . Yii::$app->user->identity->office_id . '/';
            if (!file_exists($uploadFolder)) {
                mkdir($uploadFolder, 0777, true);
            }
            $uploadedFile->saveAs($uploadFolder . $name);
            $files->file_name =$name;
            if ($files->save()) {
                
            } else {
                stop($files->getErrors());
            }
        }
        return $this->render('view', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
                    'fileDataProvider' => $fileDataProvider,
                    'fileSearchModel' => $fileSearchModel,
                    'model' => $this->findModel($id),
                    'files' => $files
        ]);
    }

    /**
     * Creates a new Cases model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new Cases();
        $model->office_id = Yii::$app->user->identity->office_id;
        $model->created_by = Yii::$app->user->identity->id;
        $model->created_on = date('Y-m-d');
        $model->next_appearing_date = "0000-00-00";
        $model->status = 1;

        if ($model->load(Yii::$app->request->post())) {
            $model->client_name = json_encode(Yii::$app->request->post('Cases')['client_name']); //convert the array into string
//             stop($model);
            $model->save();
            Yii::$app->session->setFlash('success', 'Case added successfully!');
            return $this->redirect(['index']);
//            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Cases model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->client_name = json_decode($model->client_name); //convert the array into string
        if ($model->load(Yii::$app->request->post())) {
            $model->client_name = json_encode(Yii::$app->request->post('Cases')['client_name']); //convert the array into string
            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Cases model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id) {
        $model = $this->findModel($id);
        $status = 0;
        $model->status = $status;

if(!$model->save())  {
    stop($model->getErrors());
}      $model->save();
        Yii::$app->session->setFlash('success', 'Case Deleted successfully!');
        return $this->redirect(['index']);
    }

    /**
     * Deletes an existing Cases model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionAddlist($id) {
        $model = $this->findModel($id);
        $model->list = 1;

        $model->save();
        Yii::$app->session->setFlash('success', 'Case Added to List');
        return $this->redirect(['index']);
    }

    /**
     * Deletes an existing Cases model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionRemovelist($id) {
        $model = $this->findModel($id);
        $model->list = 0;

        $model->save();
        Yii::$app->session->setFlash('success', 'Case Added to List');
        return $this->redirect(['index']);
    }

    /**
     * Finds the Cases model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Cases the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        $model = Cases::find()
                ->where(['id' => $id, 'office_id' => Yii::$app->user->identity->office_id])
                ->one();

        if ($model !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionStatusupdate($id) {

        $model = $this->findModel($id);
        $model->status = 1;
        $model->save();
        Yii::$app->session->setFlash('success', 'Case status updated successfully!');
        return $this->redirect(['index']);
    }

    /**
     * add hearing details.
     * @param integer $id
     * @return mixed
     */
    public function actionHearing($id) {
        $model = new Hearings();
        $model->case_id = $id;
        $model->office_id = Yii::$app->user->identity->office_id;
        if ($model->load(Yii::$app->request->post())) {

            if ($model->save()) {
                $case = $this->findModel($id);
                $case->next_appearing_date = $model->hearing_date;
                $case->save();
                $message = Yii::$app->params['hearing_date_updated'];
                $params = array('date' => date('l jS \of F Y', strtotime($case->next_appearing_date)), 'case_id' => $case->case_number, 'advocate' => Yii::$app->user->identity->first_name . ' ' . Yii::$app->user->identity->last_name);
                Helper::sendMessage($case->id, $message, $params);
                Yii::$app->session->setFlash('success', 'Case status updated successfully!');

                return $this->redirect(['view', 'id' => $id]);
            } else {
                if (Yii::$app->request->isAjax) {
                    Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
                    return \yii\widgets\ActiveForm::validate($model);
                }
            }
        }
        if (Yii::$app->request->isAjax) {
            return $this->renderAjax('hearing', [
                        'model' => $model, 'case' => false
            ]);
        }
    }

    public function actionDeletefile($id) {
        $file = Files::find($id)->one();
//        stop($file);
        $path = Yii::getAlias('@common') . '/../upload/' . Yii::$app->user->identity->office_id .'/'.$file->file_name;
        if (unlink($path)) {
            Files::findOne($id)->delete();
            Yii::$app->session->setFlash('success', 'File deleted successfully!');
        }else{
            Yii::$app->session->setFlash('error', 'Unable to delete file!');
        }


        return $this->redirect(Yii::$app->request->referrer);
    }

}
