<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('students', function (Blueprint $table) {
            $table->id('student_id');
            $table->string('student_regno');
            $table->string('student_name');
            $table->date('student_dob')->default('0000-00-00');
            $table->date('student_doj')->default('0000-00-00');
            $table->mediumText('student_address')->nullable();
            $table->longText('student_aadhar_file')->nullable();
            $table->longText('student_sslc_file')->nullable();
            $table->longText('student_other_file')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('students');
    }
}
