<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Student extends Model
{
    use HasFactory;

    protected $primaryKey = 'student_id';

    protected $fillable = [
        'student_regno',    
        'student_name',
        'student_dob',
        'student_doj',
        'student_branch_id',
        'student_course_id',
        'student_address'
    ];

    protected $hidden = [
        'student_branch_id',
        'student_course_id',
        'student_id'
    ];

    protected $with = [
        'branch:branch_id,branch_name',
        'course:course_id,course_name'
    ];

    protected $appends = ['student_id_generated'];

    public function getStudentIdGeneratedAttribute(){
        return encrypt($this->student_id);
    }

    public function getCreatedAtAttribute($value){
        return date('d-m-Y h:ia',strtotime($value));
    }

    public function branch(){
        return $this->hasOne(Branch::class,'branch_id','student_branch_id');
    }

    public function course(){
        return $this->hasOne(Course::class,'course_id','student_course_id');
    }

    public function certificate(){
        return $this->hasOne(Certificate::class, 'cert_student_id', 'student_id');
    }
    
}
