<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;

class Course extends Model
{
    use HasFactory;

    protected $primaryKey = 'course_id';

    protected $fillable   = [
        "course_name",
        "course_desc",
        "branch_id",
    ];

    protected $with = [
        'branch:branch_id,branch_name',
    ];

    protected $hidden = [
        'branch_id',
        'course_id'
    ];

    protected $appends = ['course_id_generated'];

    public function setCourseNameAttribute($value) {
        $this->attributes['course_name'] = strtoupper($value);
    }

    public function getCreatedAtAttribute($value){
        return date('d-m-Y h:ia',strtotime($value));
    }

    public function getCourseIdGeneratedAttribute(){ //for custom field to append
        return encrypt($this->course_id);
    }

    public function branch(){
        return $this->hasOne(Branch::class,'branch_id','branch_id'); 
    }
}
