<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Certificate extends Model
{
    use HasFactory;

    protected $primaryKey = 'cert_id';

    protected $fillable = [
        'cert_student_id',
        'cert_course_id',
        'cert_image_file'
    ];

    protected $hidden = [
        'cert_student_id',
        'cert_course_id',
        'cert_id',
        'cert_image_file'
    ];

    protected $with = [
        'student:student_id,student_name',
        'course:course_id,course_name'
    ];

    protected $appends = ['cert_id_generated','cert_image_url', 'cert_image_mime'];


    public function getCreatedAtAttribute($value){
        return date('d-m-Y h:ia',strtotime($value));
    }

    public function getCertIdGeneratedAttribute(){
        return encrypt($this->cert_id);
    }

    public function getCertImageUrlAttribute(){
        return Storage::url($this->cert_image_file);
    }

    public function getCertImageMimeAttribute(){
        return Storage::mimeType($this->cert_image_file);
    }



    public function student(){
        return $this->hasOne(Student::class,'student_id','cert_student_id');
    }

    public function course(){
        return $this->hasOne(Course::class,'course_id','cert_course_id');
    }
}
