<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;

class ApiCoursePostRequest extends FormRequest
{
    
    protected function failedValidation(Validator $validator){

        throw new HttpResponseException(response()->json([
            'status'    => false,
            'message'   => 'Validation errors',
            'data'      => [
                'errors' => $validator->errors()
            ]    
        ]));

    }
    
    
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'course_branch' => 'required',
            'course_name'   => 'required'
        ];
    }
}
