<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Requests\ApiUserPostRequest;
use App\Models\Branch;
use App\Models\Role;
use App\Models\User;

class ApiUserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = [
            'branches' => Branch::all(),
            'roles'    => Role::all()
        ];
        return $this->JsonOutPut(true, "Fetched list for users", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ApiUserPostRequest $request)
    {
        User::create([
            'name'     => $request->user_name,
            'email'    => $request->user_email,
            'password' => bcrypt($request->user_password),
            'branch_id'=> decrypt($request->user_branch),
            'role_id'  => $request->user_role
        ]);

        return $this->JsonOutPut(true,"User Created Successfully");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $limit= ($request->has('limit') && $request->limit > 0) ? $request->limit : 10;
        $page = $request->page ?? 1;
        $search_key = $request->term ?? null;
        $userWhere = "";

        if($request->has('sortable')){
            $userOrder = $this->DataTableOrderBy($request->sortable);
            $user = User::orderByRaw($userOrder);
        }
        else{
            $user = User::orderBy('created_at','desc');
        }
        
        if($search_key != null && $request->has('fields')){
            $collection = collect($request->fields); 
            $relations  = ['branch','role'];      
            
            $userWhere  = $this->DataTableWhere($request->fields,$relations, $search_key);

            $user->whereRaw($userWhere);

            if($collection->contains('branch')){
                $user->orWhereHas('branch',function($query) use ($search_key){
                    $query->where('branch_name','LIKE','%'.$search_key.'%');
                });
            }
            if($collection->contains('role')){
                $user->orWhereHas('role',function($query) use ($search_key){
                    $query->where('role_name','LIKE','%'.$search_key.'%');
                });
            }
        }
        // $sql   = $user->toSql();
        $users = $user->paginate($limit,['user_id','name','email','branch_id','role_id','status','created_at'],'users',$page);
        

        $data = [
           'users'     => $users->toArray()['data'],
           'total'     => $users->total(),
           'index'     => $users->firstItem(),
        //    'sql'       => $sql
        ];
        return $this->JsonOutPut(true,'Fetched Users list',$data);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
