<?php

namespace App\Http\Controllers;

use App\Http\Requests\ApiLoginPostRequest;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;

class ApiLoginController extends Controller
{
    public function login(ApiLoginPostRequest $request){

        $request->validated();
        
        $user = User::where('email', $request->email)->first();
        if (! $user || ! Hash::check($request->password, $user->password)) {
            $data = [
                'errors' => 'The provided credentials are incorrect.'
            ];
            return $this->JsonOutPut(false,"Validation Errors",$data);
        }

        $token = $user->createToken('front-end-app')->plainTextToken;
        $data  = [
            // 'user' => $user,
            'token'=> $token
        ];
        return $this->JsonOutPut(true,"Logged Successfully",$data);
       
    }

    public function UserDashboard(){
        $userId = auth()->user()->user_id;
        $user   = User::find($userId);
        $data   = [
            'user'   => [
                'name'   => $user->name,
                'email'  => $user->email,
                'branch' => $user->branch->branch_name,
                'role'   => $user->role->role_name
            ],
        ];
        return $this->JsonOutPut(true,"Fetched Successfully",$data);
    }

    public function UserLogout(){
        $userId = auth()->user()->user_id;
        $user   = User::find($userId);
        $user->tokens()->delete();
        return $this->JsonOutPut(true,"Logged Out Successfully");
    }
}
