<?php

namespace App\Http\Controllers;

use App\Http\Requests\ApiBranchPostRequest;
use App\Models\Branch;
use Illuminate\Http\Request;


class ApiBranchController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = [
            'branches' => Branch::all()
        ];    
        return $this->JsonOutPut(true,"Fetched Branches list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ApiBranchPostRequest $request)
    {
        Branch::create([
            'branch_name'               => $request->branch_name,
            'branch_authorised_person'  => $request->branch_authorised_person,
            'branch_phone'              => $request->branch_phone,
            'branch_address'            => $request->branch_address
        ]);
        return $this->JsonOutPut(true,"Branch Created Successfully");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $limit= ($request->has('limit') && $request->limit > 0) ? $request->limit : 10;
        $page = $request->page ?? 1;
        $search_key = $request->term ?? null;
        
        if($request->has('sortable')){
            $branchOrder = $this->DataTableOrderBy($request->sortable);
            $branch = Branch::orderByRaw($branchOrder);
        }
        else{
            $branch = Branch::orderBy('created_at','desc');
        }
        
        if($search_key != null && $request->has('fields')){
            $collection = collect($request->fields); 
            $relations  = [];      
            
            $branchWhere  = $this->DataTableWhere($request->fields,$relations, $search_key);

            $branch->whereRaw($branchWhere);

            // if($collection->contains('branch')){
            //     $branch->orWhereHas('branch',function($query) use ($search_key){
            //         $query->where('branch_name','LIKE','%'.$search_key.'%');
            //     });
            // }
        }
        // $sql   = $user->toSql();
        $branches = $branch->paginate($limit,['*'],'courses',$page);
        

        $data = [
           'branches'  => $branches->toArray()['data'],
           'total'     => $branches->total(),
           'index'     => $branches->firstItem(),
        //    'sql'       => $sql
        ];
        return $this->JsonOutPut(true,'Fetched Branches list',$data);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ApiBranchPostRequest $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
