<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->group(function () {
   Route::get('/get-user-dashboard','ApiLoginController@UserDashboard');
   Route::get('/logout','ApiLoginController@UserLogout');
   Route::post('/add-user','ApiUserController@store');
   Route::post('/add-branch','ApiBranchController@store');
   Route::get('/get-branches','ApiBranchController@index');
   Route::post('/add-course','ApiCourseController@store');
   Route::get('/get-user-options','ApiUserController@index');
   Route::post('/add-student','ApiStudentController@store');
   Route::get('/get-student-options','ApiStudentController@index');
   Route::post('/search-students','ApiStudentController@searchStudents');
   Route::post('/upload-certificates','ApiStudentController@uploadCertificate');
   Route::get('/get-users-list','ApiUserController@show');
   Route::get('/get-courses-list','ApiCourseController@show');
   Route::get('/get-branches-list','ApiBranchController@show');
   Route::get('/get-students-list','ApiStudentController@show');
   Route::get('/get-certificates-list','ApiStudentController@getCertificates');
   Route::post('/get-course-details/{id}','ApiCourseController@edit');
   Route::post('/update-course/{id}','ApiCourseController@update');
});
Route::post('/login','ApiLoginController@login');
Route::post('/upload-to-s3',function(Request $request){
   if($request->hasFile("image")){
      $extension = $request->file('image')->getClientOriginalExtension();
      $file_name = "image_".time().".".$extension;
      $file      = $request->file('image')->storeAs('uploads',$file_name);
      return [
         'status' => true,
         'data'   => $file,
         'url'    => Storage::url($file)
      ];
   }
   else{
      return [
         'status' => false,
         'msg'    => 'File not Provided'
      ];
   }
});
Route::post("/get-student-certificate","ApiStudentController@getStudentCertificate");
Route::get("/list-courses","ApiCourseController@index");

