<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCertificatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('certificates', function (Blueprint $table) {
            $table->id('cert_id');
            $table->unsignedBigInteger('cert_student_id')->comment("student");
            $table->unsignedBigInteger('cert_course_id')->comment("course");
            $table->longText('cert_image_file')->nullable();
            $table->foreign('cert_student_id')->references('student_id')->on('students');
            $table->foreign('cert_course_id')->references('course_id')->on('courses');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('certificates');
    }
}
