<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterStudentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('students', function (Blueprint $table) {
            $table->unsignedBigInteger('student_branch_id')->after('student_doj')->comment("branches");
            $table->unsignedBigInteger('student_course_id')->after('student_branch_id')->comment("Linked to courses");

            $table->foreign('student_branch_id')->references('branch_id')->on('branches');
            $table->foreign('student_course_id')->references('course_id')->on('courses');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('students', function (Blueprint $table) {
            $table->dropForeign('students_student_branch_id_foreign');
            $table->dropForeign('students_student_course_id_foreign');
        });
    }
}
