<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $primaryKey = 'user_id';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'branch_id',
        'role_id'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'user_id',
        'branch_id',
        'role_id'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    protected $appends = ['user_id_generated'];

    protected $with = [
        'branch:branch_id,branch_name',
        'role:role_id,role_name'
    ];

    public function getUserIdGeneratedAttribute(){ //for custom field to append
        return encrypt($this->user_id);
    }

    public function getCreatedAtAttribute($value){
        return date('d-m-Y h:ia',strtotime($value));
    }

    public function branch(){
        return $this->hasOne(Branch::class,'branch_id','branch_id'); //(class, 'foreign key','primary key')
    }

    public function role(){
        return $this->hasOne(Role::class,'role_id','role_id'); 
    }
}
