<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    use HasFactory;

    protected $primaryKey = 'branch_id';

    protected $fillable   = [
        "branch_name",
        "branch_authorised_person",
        "branch_phone",
        "branch_address"
    ];

    protected $hidden = ['branch_id'];

    protected $appends = ['branch_id_generated'];

    protected $withCount = [
        'students',
        'courses'
    ];

    public function getCreatedAtAttribute($value){
        return date('d-m-Y h:ia',strtotime($value));
    }

    public function getBranchIdGeneratedAttribute(){
        return encrypt($this->branch_id);
    }

    public function students(){
        return $this->hasMany(Student::class,'student_branch_id','branch_id');
    }
    public function courses(){
        return $this->hasMany(Course::class,'branch_id','branch_id');
    }
}
