<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;

class ApiStudentPostRequest extends FormRequest
{
    
    protected function failedValidation(Validator $validator){

        throw new HttpResponseException(response()->json([
            'status'    => false,
            'message'   => 'Validation errors',
            'data'      => [
                'errors' => $validator->errors()
            ]    
        ]));

    }
    
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        
        return [
            'student_branch'       => 'required',
            'student_name'         => 'required',
            'student_course'       => 'required',
            'student_admission_no' => 'required|unique:students,student_regno',
            'student_dob'          => 'required',
            'student_doj'          => 'required',
            'student_aadhar'       => 'mimes:pdf,jpeg,jpg,png|max:2048',
            'student_sslc'         => 'mimes:pdf,jpeg,jpg,png|max:2048',
            'student_others'       => 'mimes:pdf,jpeg,jpg,png|max:2048'
        ];
    }
}
