<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Collection;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function JsonOutPut($status=true,$message="Response is Successfull",$data=array(),$statusCode=200){
        return response()->json([
            'status' => $status,
            'message'=> $message,
            'data'   => $data
        ],$statusCode);
    }

    protected function DataTableWhere($fields=[],$relations=[],$search_key=""){
        $fieldsCollection = collect($fields);
        $filtered = $fieldsCollection->diff($relations);
        $tmp_arr  = $filtered->map(function($val) use ($search_key){
            return $val." like '%".$search_key."%'";
        });

        return $tmp_arr->isEmpty() ? false : $tmp_arr->join(" or ");
    }

    protected function DataTableOrderBy($fields=[]){
        $fieldsCollection = collect($fields);
        $tmp_sort_arr     = $fieldsCollection->map(function($val){
            return $val['field']." ".$val['sort'];
        });
        return $tmp_sort_arr->isEmpty() ? false : $tmp_sort_arr->join(",");
    }
}
