<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;
use yii\helpers\Url;
AppAsset::register($this);
?>
    <?php $this->beginPage() ?>
        <!DOCTYPE html>
        <html lang="<?= Yii::$app->language ?>">

        <head>
            <meta charset="<?= Yii::$app->charset ?>">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <?= Html::csrfMetaTags() ?>
                <title>
                    <?= Html::encode($this->title) ?>
                </title>
                <?php $this->head() ?>
        </head>

        <body>
            <?php $this->beginBody() ?>
                <header id="masthead" class="sticky-header site-header">
                    <div id="toolbar" class="toolbar">
                        <div class="container">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="toolbar-container">
                                        <aside id="text-2" class="widget widget_text">
                                            <div class="textwidget">
                                                <div class="thim-have-any-question"> Have any question?
                                                    <div class="mobile"><i class="fa fa-phone"></i><a href="tel:00123456789" class="value">(00) 123 456 789</a></div>
                                                    <div class="email"><i class="fa fa-envelope"></i><a href="mailto:hello@mytutellage.com">hello@mytutellage.com</a></div>
                                                </div>
                                            </div>
                                        </aside>
                                        <aside id="login-popup-3" class="widget widget_login-popup">
                                            <div class="thim-widget-login-popup thim-widget-login-popup-base">
                                                <div class="thim-link-login thim-login-popup"> <a class="register" href="<?= Yii::$app->request->baseUrl ?>/registration">Register</a></div>
                                            </div>
                                        </aside>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="container">
                        <div class="row">
                            <div class="navigation col-sm-12">
                                <!--
                            <div class="tm-table">
                                <div class="width-logo table-cell sm-logo"> </div>
                                <div class="width-navigation table-cell table-right">
                                    <ul class="nav navbar-nav menu-main-menu">
                                        <span id="magic-line" style="width: 48px; left: 438px; bottom: 26px;"></span>
                                        <li class="menu-item menu-item-type-post_type menu-item-object-page menu-item-4528 tc-menu-item tc-menu-depth-0 tc-menu-align-left tc-menu-layout-default"><a href="https://educationwp.thimpress.com/gallery/" class="tc-menu-inner">Home</a></li>
                                        <li class="menu-item menu-item-type-post_type menu-item-object-page menu-item-4528 tc-menu-item tc-menu-depth-0 tc-menu-align-left tc-menu-layout-default"><a href="https://educationwp.thimpress.com/gallery/" class="tc-menu-inner">About Us</a></li>
                                        <li class="menu-item menu-item-type-post_type menu-item-object-page menu-item-4528 tc-menu-item tc-menu-depth-0 tc-menu-align-left tc-menu-layout-default"><a href="https://educationwp.thimpress.com/gallery/" class="tc-menu-inner">Privacy Policy</a></li>
                                    </ul>
                                </div>
                            </div>
-->
                                <nav class="navbar navbar-custom" role="navigation">
                                    <div class="container">
                                        <div class="navbar-header">
                                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-main-collapse"> <i class="fa fa-bars"></i> </button> <a href="../" rel="home" class="sticky-logo"><img src="<?= Yii::$app->request->baseUrl ?>/img/logo-sticky.png" alt="MyTutelage"></a> </div>
                                        <!-- Collect the nav links, forms, and other content for toggling -->
                                        <div class="collapse navbar-collapse navbar-right navbar-main-collapse">
                                            <ul class="nav navbar-nav">
                                                <!-- Hidden li included to remove active class from about link when scrolled up past about section -->
                                                <li class="hidden">
                                                    <a href="#page-top"></a>
                                                </li>
                                                <?php 
                        if (Yii::$app->controller->action->id === 'index') {
                    ?>
                                                    <li> <a class="page-scroll" href="#about">About</a> </li>
                                                    <li> <a class="page-scroll" href="#team">Team</a> </li>
                                                    <li> <a class="page-scroll" href="#testimonials">Testimonials</a> </li>
                                                    <?php
                    }
                    ?>
                                                        <li> <a class="page-scroll" href="<?= Yii::$app->request->baseUrl ?>/contact">Contact</a> </li>
                                            </ul>
                                        </div>
                                        <!-- /.navbar-collapse -->
                                    </div>
                                    <!-- /.container -->
                                </nav>
                            </div>
                        </div>
                    </div>
                </header>
                <?php
//    NavBar::begin([
//        'brandLabel' => Yii::$app->name,
//        'brandUrl' => Yii::$app->homeUrl,
//        'options' => [
//            'class' => 'navbar-inverse navbar-fixed-top',
//        ],
//    ]);
//    if (Yii::$app->user->isGuest) {
//        $menuItems[] = ['label' => 'Registration', 'url' => ['/site/signup']];
//        $menuItems[] = ['label' => 'Login', 'url' => ['/site/login']];
//    } else {
//        $menuItems[] = '<li>'
//            . Html::beginForm(['/site/logout'], 'post')
//            . Html::submitButton(
//                'Logout (' . Yii::$app->user->identity->username . ')',
//                ['class' => 'btn btn-link logout']
//            )
//            . Html::endForm()
//            . '</li>';
//    }
//    echo Nav::widget([
//        'options' => ['class' => 'navbar-nav navbar-right'],
//        'items' => $menuItems,
//    ]);
//    NavBar::end();
    ?>
                    <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
                        <?= $content ?>
                            <footer id="colophon" class=" site-footer">
                                <div class="footer">
                                    <div class="container">
                                        <div class="row">
                                            <aside id="siteorigin-panels-builder-9" class="widget widget_siteorigin-panels-builder footer_widget">
                                                <div id="pl-w57e9cc2c86af4" class="panel-layout">
                                                    <div id="pg-w57e9cc2c86af4-0" class="panel-grid panel-no-style">
                                                        <div id="pgc-w57e9cc2c86af4-0-0" class="panel-grid-cell">
                                                            <div id="panel-w57e9cc2c86af4-0-0-0" class="so-panel widget widget_black-studio-tinymce widget_black_studio_tinymce panel-first-child" data-index="0">
                                                                <div class="textwidget">
                                                                    <div class="thim-footer-location">
                                                                        <p><img class="alignnone size-full wp-image-10" src="<?= Yii::$app->request->baseUrl ?>/img/logo-sticky.png" alt="logo-eduma-the-best-lms-wordpress-theme" width="145" height="40"></p>
                                                                        <p class="info"><i class="fa fa-phone"></i><a href="tel:00123456789">(00) 123 456 789</a></p>
                                                                        <p class="info"><i class="fa fa-envelope"></i><a href="mailto:hello@mytutelage.com">hello@mytutelage.com</a></p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div id="panel-w57e9cc2c86af4-0-0-1" class="so-panel widget widget_social panel-last-child" data-index="1">
                                                                <div class="thim-widget-social thim-widget-social-base">
                                                                    <div class="thim-social">
                                                                        <ul class="social_link">
                                                                            <li><a class="facebook hasTooltip" href="" target="_self"><i class="fa fa-facebook"></i></a></li>
                                                                            <li><a class="twitter hasTooltip" href="" target="_self"><i class="fa fa-twitter"></i></a></li>
                                                                            <li><a class="google-plus hasTooltip" href="" target="_self"><i class="fa fa-google-plus"></i></a></li>
                                                                            <li><a class="pinterest hasTooltip" href="#" target="_self"><i class="fa fa-pinterest"></i></a></li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="pgc-w57e9cc2c86af4-0-1" class="panel-grid-cell">
                                                            <div id="panel-w57e9cc2c86af4-0-1-0" class="so-panel widget widget_nav_menu panel-first-child panel-last-child" data-index="2">
                                                                <h3 class="widget-title">Company</h3>
                                                                <div class="menu-company-container">
                                                                    <ul id="menu-company" class="menu">
                                                                        <li id="menu-item-3421" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-3421 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">About Us</a></li>
                                                                        <li id="menu-item-3424" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-3424 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">Blog</a></li>
                                                                        <li id="menu-item-3422" class="menu-item menu-item-type-post_type menu-item-object-page current-menu-item page_item page-item-87 current_page_item menu-item-3422 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">Contact</a></li>
                                                                        <li id="menu-item-3423" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-3423 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">Become a Teacher</a></li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="pgc-w57e9cc2c86af4-0-2" class="panel-grid-cell">
                                                            <div id="panel-w57e9cc2c86af4-0-2-0" class="so-panel widget widget_nav_menu panel-first-child panel-last-child" data-index="3">
                                                                <h3 class="widget-title">Links</h3>
                                                                <div class="menu-links-container">
                                                                    <ul id="menu-links" class="menu">
                                                                        <li id="menu-item-5749" class="menu-item menu-item-type-post_type_archive menu-item-object-lp_course menu-item-5749 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">Courses</a></li>
                                                                        <li id="menu-item-3426" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-3426 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">Events</a></li>
                                                                        <li id="menu-item-4591" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-4591 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">Gallery</a></li>
                                                                        <li id="menu-item-3427" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-3427 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">FAQs</a></li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="pgc-w57e9cc2c86af4-0-3" class="panel-grid-cell">
                                                            <div id="panel-w57e9cc2c86af4-0-3-0" class="so-panel widget widget_nav_menu panel-first-child panel-last-child" data-index="4">
                                                                <h3 class="widget-title">Support</h3>
                                                                <div class="menu-support-container">
                                                                    <ul id="menu-support" class="menu">
                                                                        <li id="menu-item-1757" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-1757 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">Documentation</a></li>
                                                                        <li id="menu-item-1758" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-1758 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">Forums</a></li>
                                                                        <li id="menu-item-1759" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-1759 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="#" class="tc-menu-inner">Language Packs</a></li>
                                                                        <li id="menu-item-1760" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-1760 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="#" class="tc-menu-inner">Release Status</a></li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="pgc-w57e9cc2c86af4-0-4" class="panel-grid-cell">
                                                            <div id="panel-w57e9cc2c86af4-0-4-0" class="so-panel widget widget_nav_menu panel-first-child panel-last-child" data-index="5">
                                                                <h3 class="widget-title">Recommend</h3>
                                                                <div class="menu-recommend-container">
                                                                    <ul id="menu-recommend" class="menu">
                                                                        <li id="menu-item-1757" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-1757 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">Documentation</a></li>
                                                                        <li id="menu-item-1758" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-1758 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="" class="tc-menu-inner">Forums</a></li>
                                                                        <li id="menu-item-1759" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-1759 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="#" class="tc-menu-inner">Language Packs</a></li>
                                                                        <li id="menu-item-1760" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-1760 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="#" class="tc-menu-inner">Release Status</a></li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </aside>
                                        </div>
                                    </div>
                                </div>
                                <div class="copyright-area">
                                    <div class="container">
                                        <div class="copyright-content">
                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <p class="text-copyright">Mytutelage  &copy;
                        <?= date('Y') ?> Powered by <a href="http://www.heavens.co.in/" rel="external">Heavens</a></p>
                                                </div>
                                                <div class="col-sm-6 text-right">
                                                    <aside id="nav_menu-14" class="widget widget_nav_menu">
                                                        <div class="menu-privacy-container">
                                                            <ul id="menu-privacy" class="menu">
                                                                <li id="menu-item-1765" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-1765 tc-menu-item tc-menu-depth-0 tc-menu-layout-default"><a href="<?= Yii::$app->request->baseUrl ?>/privacy" class="tc-menu-inner">Privacy policy</a></li>
                                                                
                                                            </ul>
                                                        </div>
                                                    </aside>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </footer>
                            <!--<div class="footer-bottom"><div class="container"><aside id="siteorigin-panels-builder-7" class="widget widget_siteorigin-panels-builder footer_bottom_widget"><div id="pl-w57babc3f18d14" class="panel-layout"><div id="pg-w57babc3f18d14-0" class="panel-grid panel-has-style"><div class="thim-bg-overlay-color-half siteorigin-panels-stretch panel-row-style panel-row-style-for-w57babc3f18d14-0" data-stretch-type="full" style="margin-left: -366.5px; margin-right: -366.5px; padding-left: 366.5px; padding-right: 366.5px; border-left: 0px; border-right: 0px;"><div id="pgc-w57babc3f18d14-0-0" class="panel-grid-cell"><div id="panel-w57babc3f18d14-0-0-0" class="so-panel widget widget_heading panel-first-child" data-index="0"><div class="thim-widget-heading thim-widget-heading-base"><div class="sc_heading text-center"><h3 style="color:#333333;" class="title">Become an instructor?</h3><p class="sub-heading" style="color:#333333;">Join thousand of instructors and earn money hassle free!</p><span class="line"></span></div></div></div><div id="panel-w57babc3f18d14-0-0-1" class="so-panel widget widget_button panel-last-child" data-index="1"><div class="thim-widget-button thim-widget-button-base"><a class="widget-button  normal" href="https://themeforest.net/item/education-wordpress-theme-education-wp/14058034?ref=ThimPress&amp;utm_source=demo&amp;utm_medium=demofooter" style="" data-hover="">Get Started Now</a></div></div></div></div></div></div></aside></div></div>        -->
                            <!--
        <footer class="footer">
            <div class="container">
                <p class="pull-left">&copy;
                    <?= Html::encode(Yii::$app->name) ?>
                        <?= date('Y') ?>
                </p>

                <p class="pull-right">Powered by <a href="http://www.heavens.co.in/" rel="external">Heavens</a></p>
            </div>
        </footer>
-->
                            <?php $this->endBody() ?>
        </body>

        </html>
        <?php $this->endPage() ?>