<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;
use yii\helpers\Url;
AppAsset::register($this);
?>
    <?php $this->beginPage() ?>
        <!DOCTYPE html>
        <html lang="<?= Yii::$app->language ?>">

        <head>
            <meta charset="<?= Yii::$app->charset ?>">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <?= Html::csrfMetaTags() ?>
                <title>
                    <?= Html::encode($this->title) ?>
                </title>
                <?php $this->head() ?>
        </head>

        <body>
            <?php $this->beginBody() ?>
                <header id="masthead" class="sticky-header site-header">
                    <div class="container">
                        <div class="row">
                            <div class="navigation col-sm-12">
                                <nav class="navbar navbar-custom" role="navigation">
                                    <div class="container">
                                        <div class="navbar-header">
                                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-main-collapse"> <i class="fa fa-bars"></i> </button> <a href="../" rel="home" class="sticky-logo"><img src="<?= Yii::$app->request->baseUrl ?>/img/logo-sticky.png" alt="Bhagyarekha"></a> </div>
                                        <!-- Collect the nav links, forms, and other content for toggling -->
                                        <div class="collapse navbar-collapse navbar-right navbar-main-collapse">
                                            <ul class="nav navbar-nav">
                                                <!-- Hidden li included to remove active class from about link when scrolled up past about section -->
                                                <li class="hidden">
                                                    <a href="#page-top"></a>
                                                </li>
                                                <?php 
                        if (Yii::$app->controller->action->id === 'index') {
                    ?>
                                                    <!-- <li> <a class="page-scroll" href="#about">About</a> </li>
                                                    <li> <a class="page-scroll" href="#team">Topics</a> </li>
                                                    <li> <a class="page-scroll" href="#testimonials">Prices</a> </li> -->
                                                    <li> <a class="page-scroll register" href="<?= Yii::$app->request->baseUrl ?>/quiz-registration">Register Quiz</a> </li>
                                                    <?php
                    }
                    ?>
                                                        
                                            </ul>
                                        </div>
                                        <!-- /.navbar-collapse -->
                                    </div>
                                    <!-- /.container -->
                                </nav>
                            </div>
                        </div>
                    </div>
                </header>
                <?php
//    NavBar::begin([
//        'brandLabel' => Yii::$app->name,
//        'brandUrl' => Yii::$app->homeUrl,
//        'options' => [
//            'class' => 'navbar-inverse navbar-fixed-top',
//        ],
//    ]);
//    if (Yii::$app->user->isGuest) {
//        $menuItems[] = ['label' => 'Registration', 'url' => ['/site/signup']];
//        $menuItems[] = ['label' => 'Login', 'url' => ['/site/login']];
//    } else {
//        $menuItems[] = '<li>'
//            . Html::beginForm(['/site/logout'], 'post')
//            . Html::submitButton(
//                'Logout (' . Yii::$app->user->identity->username . ')',
//                ['class' => 'btn btn-link logout']
//            )
//            . Html::endForm()
//            . '</li>';
//    }
//    echo Nav::widget([
//        'options' => ['class' => 'navbar-nav navbar-right'],
//        'items' => $menuItems,
//    ]);
//    NavBar::end();
    ?>
                    <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
                        <?= $content ?>
                        
                            

                            <?php $this->endBody() ?>
        </body>

        </html>
        <?php $this->endPage() ?>