<?php

namespace common\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\QuizRegistration;

/**
 * QuizRegistrationSearch represents the model behind the search form of `common\models\QuizRegistration`.
 */
class QuizRegistrationSearch extends QuizRegistration
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'pin_code'], 'integer'],
            [['name', 'dob', 'gender', 'email', 'district', 'parrant_guardian', 'contact_no', 'whatsapp_no', 'address', 'institution_type', 'institution_name', 'class'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = QuizRegistration::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'pin_code' => $this->pin_code,
        ]);

        $query->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'dob', $this->dob])
            ->andFilterWhere(['like', 'gender', $this->gender])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'district', $this->district])
            ->andFilterWhere(['like', 'parrant_guardian', $this->parrant_guardian])
            ->andFilterWhere(['like', 'contact_no', $this->contact_no])
            ->andFilterWhere(['like', 'whatsapp_no', $this->whatsapp_no])
            ->andFilterWhere(['like', 'address', $this->address])
            ->andFilterWhere(['like', 'institution_type', $this->institution_type])
            ->andFilterWhere(['like', 'institution_name', $this->institution_name])
            ->andFilterWhere(['like', 'class', $this->class]);

        return $dataProvider;
    }
}
